package io.github.fishstiz.packed_packs.gui.components.pack;

import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuItemBuilder;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.Sprite;
import io.github.fishstiz.packed_packs.config.PackOverride;
import io.github.fishstiz.packed_packs.config.Profile;
import io.github.fishstiz.packed_packs.gui.components.SelectionContext;
import io.github.fishstiz.packed_packs.pack.PackOptionsContext;
import io.github.fishstiz.packed_packs.pack.ProfileScope;
import io.github.fishstiz.packed_packs.transform.interfaces.ConfiguredPack;
import io.github.fishstiz.packed_packs.transform.interfaces.FilePack;
import io.github.fishstiz.packed_packs.util.PackUtil;
import io.github.fishstiz.packed_packs.util.ResourceUtil;
import io.github.fishstiz.packed_packs.util.constants.Theme;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3288;
import net.minecraft.class_332;
import net.minecraft.class_5244;
import net.minecraft.class_7919;

import static io.github.fishstiz.packed_packs.gui.components.ToggleableHelper.getDefaultIcon;
import static io.github.fishstiz.packed_packs.util.constants.GuiConstants.*;
import static io.github.fishstiz.packed_packs.util.constants.GuiConstants.devItem;
import static io.github.fishstiz.fidgetz.util.lang.ObjectsUtil.pick;

public record PackListDevMenu(
        class_310 minecraft,
        PackOptionsContext options,
        SelectionContext<class_3288> context,
        Consumer<Event<?>> listener
) {
    private static final int DEV_SPRITE_SIZE = 16;
    private static final int DEV_SPRITE_MARGIN_RIGHT = 8;
    private static final Sprite EYE_SLASH_SPRITE = Sprite.of16(ResourceUtil.getIcon("eye_slash"));
    private static final Sprite X_SQUARE = Sprite.of16(ResourceUtil.getIcon("x_square"));
    private static final Sprite ARROW_UP_SPRITE = Sprite.of16(ResourceUtil.getIcon("arrow_up"));
    private static final Sprite ARROW_DOWN_SPRITE = Sprite.of16(ResourceUtil.getIcon("arrow_down"));
    private static final Sprite ARROWS_SPRITE = Sprite.of16(ResourceUtil.getIcon("arrows_vertical"));
    private static final Sprite RADIO_GLOBAL = Sprite.of16(ResourceUtil.getIcon("radio_globe"));
    private static final Sprite ALIAS_SPRITE = Sprite.of16(ResourceUtil.getIcon("alias"));
    private static final class_2561 HIDDEN = overrideText("hidden");
    private static final class_2561 REQUIRED = overrideText("required");
    private static final class_2561 FIXED_POSITION = overrideText("fixed");
    private static final class_2561 FIXED_TOP = overrideText("fixed.top");
    private static final class_2561 FIXED_BOTTOM = overrideText("fixed.bottom");
    private static final class_2561 REMOVE_OVERRIDES = overrideText("remove");
    private static final class_7919 REQUIRED_NO_DISABLED_INFO = class_7919.method_47407(overrideText("required.no.disabled.info"));

    public sealed interface Event<T> {
        class_3288 trigger();

        List<class_3288> packs();

        T value();

        record EditAliases(class_3288 trigger, Boolean value) implements Event<Boolean> {
            public List<class_3288> packs() {
                return List.of(this.trigger);
            }
        }

        record Hide(class_3288 trigger, Boolean value, List<class_3288> packs) implements Event<Boolean> {
        }

        record Require(class_3288 trigger, @Nullable Boolean value, List<class_3288> packs) implements Event<Boolean> {
        }

        record Reposition(
                class_3288 trigger,
                @Nullable PackOverride.Position value,
                List<class_3288> packs
        ) implements Event<PackOverride.Position> {
        }
    }

    @FunctionalInterface
    private interface EventFactory<T> {
        Event<T> create(class_3288 pack, T value, List<class_3288> packs);
    }

    private <T> void notifyListener(T value, List<class_3288> packs, EventFactory<T> eventFactory) {
        if (this.listener != null) {
            this.listener.accept(eventFactory.create(this.pack(), value, packs));
        }
    }

    private static class_2561 overrideText(String keySuffix) {
        return ResourceUtil.getText("profile.override." + keySuffix);
    }

    private class_3288 pack() {
        return this.context.item();
    }

    private ProfileScope hasOverride(BiPredicate<Profile, class_3288> option) {
        return this.options.hasOverride(this.context.item(), option);
    }

    private List<class_3288> getPackOrSelection() {
        return this.context.getItemOrSelection();
    }

    public void renderDevSprites(class_332 guiGraphics, int top, int left, int width) {
        int size = DEV_SPRITE_SIZE;
        int iconX = (left + width) - size - DEV_SPRITE_MARGIN_RIGHT;

        ProfileScope positionOverride = this.hasOverride(Profile::overridesPosition);
        if (positionOverride.exists()) {
            boolean unfixed = !this.options.isFixed(this.pack());
            boolean fixedTop = this.options.getPosition(this.pack()) == class_3288.class_3289.field_14280;
            guiGraphics.method_25294(iconX, top, iconX + size, top + size, getBackgroundColor(positionOverride));
            pick(unfixed, ARROWS_SPRITE, pick(fixedTop, ARROW_UP_SPRITE, ARROW_DOWN_SPRITE)).render(guiGraphics, iconX, top, size, size);
            iconX -= size;
        }
        ProfileScope requiredOverride = this.hasOverride(Profile::overridesRequired);
        if (requiredOverride.exists()) {
            boolean required = this.options.isRequired(this.pack());
            guiGraphics.method_25294(iconX, top, iconX + size, top + size, getBackgroundColor(requiredOverride));
            pick(required, LOCK_SPRITE_SMALL, UNLOCK_SPRITE_SMALL).render(guiGraphics, iconX, top, size, size);
            iconX -= size;
        }
        ProfileScope hiddenOverride = this.hasOverride(Profile::isHidden);
        if (hiddenOverride.exists()) {
            guiGraphics.method_25294(iconX, top, iconX + size, top + size, getBackgroundColor(hiddenOverride));
            EYE_SLASH_SPRITE.render(guiGraphics, iconX, top, size, size);
            iconX -= size;
        }
        ProfileScope included = this.hasOverride(Profile::includes);
        if (included.global() && !((ConfiguredPack) this.pack()).packed_packs$getMetadata().comp_1583().method_14437()) {
            guiGraphics.method_25294(iconX, top, iconX + size, top + size, Theme.RED_700.withAlpha(0.75f));
            X_SQUARE.render(guiGraphics, iconX, top, size, size);
            iconX -= size;
        }
        if (this.options.getConfig().hasAlias(this.pack().method_14463())) {
            guiGraphics.method_25294(iconX, top, iconX + size, top + size, Theme.GREEN_500.withAlpha(0.75f));
            ALIAS_SPRITE.render(guiGraphics, iconX, top, size, size);
        }
    }

    private void updateHidden(boolean hidden) {
        this.options.getProfile().ifPresent(profile -> {
            List<class_3288> selected = this.getPackOrSelection();
            profile.setHidden(hidden, selected);
            this.notifyListener(hidden, selected, Event.Hide::new);
        });
    }

    private void updateRequired(@Nullable Boolean required) {
        this.options.getProfile().ifPresent(profile -> {
            List<class_3288> selected = this.getPackOrSelection();
            profile.setRequired(required, selected);
            this.notifyListener(required, selected, Event.Require::new);
        });
    }

    private void updatePosition(@Nullable PackOverride.Position position) {
        this.options.getProfile().ifPresent(profile -> {
            List<class_3288> selected = this.getPackOrSelection();
            profile.setPosition(position, selected);
            this.notifyListener(position, selected, Event.Reposition::new);
        });
    }

    private void resetOverrides() {
        this.updateHidden(false);
        this.updateRequired(null);
        this.updatePosition(null);
    }

    private Sprite getIcon(boolean active, BiPredicate<Profile, class_3288> defaultOption) {
        return this.hasOverride(defaultOption) == ProfileScope.GLOBAL ? RADIO_GLOBAL : getDefaultIcon(active);
    }

    private boolean canDisableRequired() {
        return this.options.isDefaultProfile() && !PackUtil.isEssential(this.pack());
    }

    private void buildNonOverrideOptions(ContextMenuItemBuilder builder) {
        builder.add(devItem(class_5244.field_62056)
                .action(() -> this.minecraft.field_1774.method_1455(this.pack().method_14463()))
                .build()
        ).separator();

        builder.add(devItem(ResourceUtil.getText("aliases.edit"))
                .action(() -> this.listener.accept(new Event.EditAliases(this.pack(), this.options.getConfig().hasAlias(this.pack().method_14463()))))
                .build()
        ).separator();
    }

    public void onBuildHeader(ContextMenuItemBuilder builder) {
        Profile profile = this.options.getProfile().orElse(null);
        if (profile == null) {
            this.buildNonOverrideOptions(builder);
            return;
        }

        builder.add(devItem(HIDDEN)
                .icon(() -> this.getIcon(profile.isHidden(this.pack()), Profile::isHidden))
                .activeWhen(() -> this.hasOverride(Profile::isHidden) != ProfileScope.GLOBAL)
                .action(() -> this.updateHidden(!profile.isHidden(this.pack())))
                .closeOnInteract(false)
                .build());

        builder.add(devItem(REQUIRED)
                .icon(() -> this.options.isLocked()
                        ? LOCK_SPRITE_SMALL
                        : this.getIcon(profile.overridesRequired(this.pack()), Profile::overridesRequired))
                .activeWhen(() -> !this.options.isLocked() &&
                                  this.hasOverride(Profile::overridesRequired) != ProfileScope.GLOBAL &&
                                  !((FilePack) this.pack()).packed_packs$nestedPack())
                .closeOnInteract(false)
                .addChild(devItem(class_5244.field_24333)
                        .icon(() -> getDefaultIcon(!profile.overridesRequired(this.pack())))
                        .action(() -> this.updateRequired(null))
                        .closeOnInteract(false)
                        .build())
                .addChild(devItem(class_5244.field_24337)
                        .icon(() -> getDefaultIcon(profile.overridesRequired(this.pack()) && !profile.isRequired(this.pack())))
                        .activeWhen(this::canDisableRequired)
                        .tooltip(() -> !this.canDisableRequired() && !PackUtil.isEssential(this.pack()) ? REQUIRED_NO_DISABLED_INFO : null)
                        .action(() -> this.updateRequired(false))
                        .closeOnInteract(false)
                        .build())
                .addChild(devItem(class_5244.field_24336)
                        .icon(() -> getDefaultIcon(profile.isRequired(this.pack())))
                        .action(() -> this.updateRequired(true))
                        .closeOnInteract(false)
                        .build())
                .build());

        builder.add(devItem(FIXED_POSITION)
                .icon(() -> this.getIcon(profile.overridesPosition(this.pack()), Profile::overridesPosition))
                .activeWhen(() -> this.hasOverride(Profile::overridesPosition) != ProfileScope.GLOBAL)
                .closeOnInteract(false)
                .addChild(devItem(class_5244.field_24333)
                        .icon(() -> getDefaultIcon(!profile.overridesPosition(this.pack())))
                        .action(() -> this.updatePosition(null))
                        .closeOnInteract(false)
                        .build())
                .addChild(devItem(class_5244.field_24337)
                        .icon(() -> getDefaultIcon(profile.overridesPosition(this.pack()) && !profile.isFixed(this.pack())))
                        .action(() -> this.updatePosition(PackOverride.Position.UNFIXED))
                        .closeOnInteract(false)
                        .build())
                .addChild(devItem(FIXED_TOP)
                        .icon(() -> getDefaultIcon(profile.getPositionOverride(this.pack()) == PackOverride.Position.TOP))
                        .action(() -> this.updatePosition(PackOverride.Position.TOP))
                        .closeOnInteract(false)
                        .build())
                .addChild(devItem(FIXED_BOTTOM)
                        .icon(() -> getDefaultIcon(profile.getPositionOverride(this.pack()) == PackOverride.Position.BOTTOM))
                        .action(() -> this.updatePosition(PackOverride.Position.BOTTOM))
                        .closeOnInteract(false)
                        .build())
                .build());

        builder.add(devItem(REMOVE_OVERRIDES).action(this::resetOverrides).build()).separator();

        this.buildNonOverrideOptions(builder);
    }

    private static int getBackgroundColor(ProfileScope overrideScope) {
        return switch (overrideScope) {
            case NONE -> Theme.WHITE.withAlpha(0);
            case LOCAL -> Theme.BLACK.withAlpha(0.75f);
            case GLOBAL -> Theme.BLUE_500.withAlpha(0.75f);
            case COMPOSITE -> Theme.PURPLE_500.withAlpha(0.75f);
        };
    }
}
