/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.compat;

import io.github.fishstiz.packed_packs.PackedPacks;
import io.github.fishstiz.packed_packs.util.ResourceUtil;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_2960;
import org.apache.commons.lang3.function.TriConsumer;

public interface ModContext {
    public String getId();

    public boolean isLoaded();

    default public class_2960 getInternalId() {
        return ResourceUtil.getResource(this.getId());
    }

    private void logError(Throwable e) {
        PackedPacks.LOGGER.warn("[packed_packs] Error occurred while applying compatibility for mod '{}'", (Object)this.getId(), (Object)e);
    }

    default public <T> T wrapError(Supplier<T> supplier, T defaultValue) {
        if (this.isLoaded()) {
            try {
                return supplier.get();
            }
            catch (Exception | LinkageError e) {
                this.logError(e);
            }
        }
        return defaultValue;
    }

    default public <T, R> R wrapError(Function<T, R> mapper, R defaultValue, T value) {
        if (this.isLoaded()) {
            try {
                return mapper.apply(value);
            }
            catch (Exception | LinkageError e) {
                this.logError(e);
            }
        }
        return defaultValue;
    }

    default public <T> void wrapError(T arg, Consumer<T> consumer) {
        if (this.isLoaded()) {
            try {
                consumer.accept(arg);
            }
            catch (Exception | LinkageError e) {
                this.logError(e);
            }
        }
    }

    default public <T1, T2> void wrapError(T1 arg1, T2 arg2, BiConsumer<T1, T2> consumer) {
        if (this.isLoaded()) {
            try {
                consumer.accept(arg1, arg2);
            }
            catch (Exception | LinkageError e) {
                this.logError(e);
            }
        }
    }

    default public <T1, T2, T3> void wrapError(T1 arg1, T2 arg2, T3 arg3, TriConsumer<T1, T2, T3> consumer) {
        if (this.isLoaded()) {
            try {
                consumer.accept(arg1, arg2, arg3);
            }
            catch (Exception | LinkageError e) {
                this.logError(e);
            }
        }
    }
}

