/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.config;

import io.github.fishstiz.fidgetz.util.lang.CollectionsUtil;
import io.github.fishstiz.packed_packs.PackedPacks;
import io.github.fishstiz.packed_packs.config.ConfigFixer;
import io.github.fishstiz.packed_packs.config.ModPreferences;
import io.github.fishstiz.packed_packs.platform.Services;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class Preferences {
    public static final Preferences INSTANCE = Preferences.load();
    private final Map<Spec<?>, Option<?>> options = new Reference2ObjectOpenHashMap();
    public final Option<Boolean> originalScreenWidget = new Option<Boolean>(this, "original_screen", true);
    public final Option<Boolean> optionsWidget = new Option<Boolean>(this, "options", true);
    public final Option<Boolean> actionBarWidget = new Option<Boolean>(this, "action_bar", true);
    public final Option<Boolean> toggleIncompatibleWidget = new Option<Boolean>(this, "toggle_incompatible", true);
    public final Option<Boolean> folderPackWidget = new Option<Boolean>(this, "folder_pack", true);

    private Preferences() {
        CollectionsUtil.forEach((Object[])ModPreferences.values(), x$0 -> new Option(this, x$0));
        Services.PLATFORM.getPreferences().forEach(x$0 -> new Option(this, x$0));
    }

    public <T> Optional<Option<T>> get(Spec<T> spec) {
        return Optional.ofNullable(this.options.get(spec));
    }

    public <T> Option<T> getOrThrow(Spec<T> spec) {
        return Objects.requireNonNull(this.options.get(spec), spec.key());
    }

    private static File getFile() {
        return PackedPacks.getConfigDir().resolve("preferences.properties").toFile();
    }

    private static Preferences load() {
        Preferences prefs = new Preferences();
        File file = Preferences.getFile();
        if (!file.exists() && !(file = ConfigFixer.getPreviousPreferencesFile()).exists()) {
            return prefs;
        }
        Properties props = new Properties();
        try (FileInputStream fis = new FileInputStream(file);){
            props.load(fis);
            for (Option<?> entry : prefs.options.values()) {
                String key = entry.getKey();
                String value = props.getProperty(key);
                entry.deserializeAndSet(value);
            }
        }
        catch (IOException | NumberFormatException e) {
            PackedPacks.LOGGER.error("[packed_packs] Failed to load preferences. ", (Throwable)e);
        }
        return prefs;
    }

    public void reset() {
        this.options.values().forEach(Option::reset);
    }

    public void save() {
        Properties props = new Properties();
        for (Option<?> entry : this.options.values()) {
            props.setProperty(entry.getKey(), entry.get().toString());
        }
        try (FileOutputStream fos = new FileOutputStream(Preferences.getFile());){
            props.store(fos, "Preferences");
        }
        catch (IOException e) {
            PackedPacks.LOGGER.error("[packed_packs] Failed to save preferences. ", (Throwable)e);
        }
    }

    public class Option<T> {
        private final Spec<T> spec;
        private T value;

        private Option(Preferences this$0, Spec<T> spec) {
            this.spec = spec;
            this.value = spec.defaultValue();
            this$0.options.put(spec, this);
        }

        private Option(Preferences this$0, String key, @Nullable T defaultValue, Function<String, T> deserializer) {
            this(this$0, Spec.create(key, defaultValue, deserializer == null ? Option.getDefaultDeserializer(defaultValue) : deserializer));
        }

        private Option(Preferences this$0, String key, T defaultValue) {
            this(this$0, key, defaultValue, null);
        }

        public void set(T value) {
            this.value = value;
        }

        public T get() {
            return this.value;
        }

        public String getKey() {
            return this.spec.key();
        }

        public T getDefault() {
            return this.spec.defaultValue();
        }

        public void reset() {
            this.value = this.getDefault();
        }

        void deserializeAndSet(@Nullable String value) {
            if (value == null) {
                this.value = this.getDefault();
                return;
            }
            try {
                this.value = this.spec.deserialize(value);
            }
            catch (Exception e) {
                this.value = this.getDefault();
                PackedPacks.LOGGER.error("[packed_packs] Failed to read preference '{}' with value '{}'. ", new Object[]{this.spec.key(), value, e});
            }
        }

        static <T> Function<String, T> getDefaultDeserializer(T defaultValue) {
            if (defaultValue instanceof Boolean) {
                return value -> Boolean.parseBoolean(value);
            }
            if (defaultValue instanceof Integer) {
                return value -> Integer.parseInt(value);
            }
            if (defaultValue instanceof String) {
                return value -> value;
            }
            throw new UnsupportedOperationException("No default deserializer for " + String.valueOf(defaultValue));
        }
    }

    public static interface Spec<T> {
        public String key();

        public T defaultValue();

        public T deserialize(String var1);

        public static <T> Spec<T> create(final String key, final T defaultValue, final Function<String, T> deserializer) {
            return new Spec<T>(){

                @Override
                public String key() {
                    return key;
                }

                @Override
                public T defaultValue() {
                    return defaultValue;
                }

                @Override
                public T deserialize(String value) {
                    return deserializer.apply(value);
                }
            };
        }
    }
}

