/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.gui.components.pack;

import io.github.fishstiz.fidgetz.gui.components.FidgetzButton;
import io.github.fishstiz.fidgetz.gui.components.FidgetzText;
import io.github.fishstiz.fidgetz.gui.components.ToggleableDialog;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuContainer;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuItemBuilder;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.MenuItem;
import io.github.fishstiz.fidgetz.gui.renderables.RenderableRect;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.Sprite;
import io.github.fishstiz.fidgetz.gui.shapes.GuiRectangle;
import io.github.fishstiz.fidgetz.util.DrawUtil;
import io.github.fishstiz.fidgetz.util.lang.ObjectsUtil;
import io.github.fishstiz.packed_packs.gui.components.contextmenu.PackMenuHeader;
import io.github.fishstiz.packed_packs.gui.components.events.FileDeleteEvent;
import io.github.fishstiz.packed_packs.gui.components.events.FileRenameOpenEvent;
import io.github.fishstiz.packed_packs.gui.components.events.FolderCloseEvent;
import io.github.fishstiz.packed_packs.gui.components.events.PackListEvent;
import io.github.fishstiz.packed_packs.gui.components.events.PackListEventListener;
import io.github.fishstiz.packed_packs.gui.components.pack.FolderPackList;
import io.github.fishstiz.packed_packs.gui.components.pack.PackList;
import io.github.fishstiz.packed_packs.pack.PackAssetManager;
import io.github.fishstiz.packed_packs.pack.PackFileOperations;
import io.github.fishstiz.packed_packs.pack.PackOptionsContext;
import io.github.fishstiz.packed_packs.pack.folder.FolderPack;
import io.github.fishstiz.packed_packs.transform.interfaces.FilePack;
import io.github.fishstiz.packed_packs.util.PackUtil;
import io.github.fishstiz.packed_packs.util.constants.GuiConstants;
import java.nio.file.Path;
import net.minecraft.class_2561;
import net.minecraft.class_3288;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_8021;
import org.jetbrains.annotations.Nullable;

public class FolderDialog
extends ToggleableDialog<FolderPackList>
implements ContextMenuContainer {
    private static final class_2561 BACK_TEXT = class_5244.field_24339.method_27661().method_10852(class_5244.field_39678);
    private static final int HEADER_HEIGHT = 16;
    private final FidgetzButton<Void> closeButton;
    private final FidgetzText<Void> folderTitle;
    private final PackFileOperations fileOps;
    private final PackListEventListener listener;
    private Sprite folderSprite = PackAssetManager.DEFAULT_FOLDER_ICON;
    private PackList parent;
    private FolderPack folderPack;

    public <S extends class_437 & PackListEventListener> FolderDialog(S screen, PackOptionsContext options, PackAssetManager assets, PackFileOperations fileOps) {
        super(FolderDialog.builder(screen, (class_8021)new FolderPackList(options, assets, fileOps, screen)).setBackground((RenderableRect)DrawUtil.DEMO_BACKGROUND));
        this.listener = screen;
        this.fileOps = fileOps;
        this.closeButton = (FidgetzButton)this.addRenderableWidget((class_364)((FidgetzButton.Builder)FidgetzButton.builder().setOnPress(() -> this.sendEvent(new FolderCloseEvent((FolderPackList)this.root(), this.folderPack))).makeSquare(GuiConstants.CROSS_SPRITE.width)).spriteOnly().build());
        this.folderTitle = (FidgetzText)this.addRenderableWidget((class_364)((FidgetzText.Builder)FidgetzText.builder().setHeight(GuiConstants.CROSS_SPRITE.height)).setOffsetY(1).setShadow(true).build());
        ((FolderPackList)this.root()).field_22764 = false;
        this.addListener(open -> {
            ((FolderPackList)this.root()).field_22764 = open;
            if (!open.booleanValue()) {
                this.sendEvent(new FolderCloseEvent((FolderPackList)this.root(), this.folderPack));
            }
        });
        ((FolderPackList)this.root()).method_48206(arg_0 -> ((FolderDialog)this).addRenderableWidget(arg_0));
    }

    private void updateBounds() {
        GuiRectangle bounds = this.getBoundingBox();
        int parentX = bounds.method_46426();
        int parentY = bounds.method_46427();
        int parentWidth = bounds.method_25368();
        int parentHeight = bounds.method_25364();
        int left = parentX + 8;
        int top = parentY + 8;
        int right = parentX + parentWidth - 8;
        int bottom = parentY + parentHeight - 8;
        ((FolderPackList)this.root()).method_48229(left, top + 16 + 8);
        ((FolderPackList)this.root()).method_25358(right - left);
        ((FolderPackList)this.root()).method_53533(bottom - ((FolderPackList)this.root()).method_46427());
        this.closeButton.method_48229(left, top);
        this.folderTitle.method_48229(left + this.closeButton.method_25368() + 8, top);
        this.folderTitle.method_25358(bounds.getRight() - this.folderTitle.method_46426() - 16);
    }

    public void updateFolder(PackList parent, FolderPack folderPack, PackAssetManager assets) {
        this.parent = parent;
        this.folderPack = folderPack;
        this.folderTitle.method_25355(folderPack.method_14457());
        assets.getOrLoadIcon(folderPack, icon -> {
            this.folderSprite = icon;
        });
        this.setBoundingBox((class_8021)parent);
        this.updateBounds();
    }

    protected void renderBackground(class_332 guiGraphics, int x, int y, int width, int height, int mouseX, int mouseY, float partialTick) {
        this.updateBounds();
        super.renderBackground(guiGraphics, x, y, width, height, mouseX, mouseY, partialTick);
    }

    protected void renderForeground(class_332 guiGraphics, int x, int y, int width, int height, int mouseX, int mouseY, float partialTick) {
        int left = this.closeButton.method_46426();
        int top = this.closeButton.method_46427();
        this.folderSprite.renderClamped(guiGraphics, left, top, GuiConstants.CROSS_SPRITE.width, GuiConstants.CROSS_SPRITE.height, partialTick);
        if (this.closeButton.method_49606()) {
            GuiConstants.WHITE_OVERLAY.render(guiGraphics, left, top, GuiConstants.CROSS_SPRITE.width, GuiConstants.CROSS_SPRITE.height);
            GuiConstants.CROSS_SPRITE.render(guiGraphics, left, top);
        }
    }

    @Nullable
    public PackList getParent() {
        return this.parent;
    }

    @Nullable
    public FolderPack getFolderPack() {
        return this.folderPack;
    }

    public void buildItems(ContextMenuItemBuilder builder, int mouseX, int mouseY) {
        super.buildItems((ContextMenuItemBuilder)builder.when(this.folderPack != null && this.isOpen()).ifTrue(folderMenuBuilder -> folderMenuBuilder.add((MenuItem)new PackMenuHeader(this.folderPack, this.folderSprite)).simpleItem(BACK_TEXT, () -> this.setOpen(false)).when(((FolderPackList)this.root()).method_19355(mouseX, mouseY).isEmpty()).ifTrue(b -> b.whenNonNull((Object)((Path)ObjectsUtil.mapOrNull((Object)this.folderPack, FilePack::packed_packs$getPath))).ifTrue((path, operationsMenuBuilder) -> operationsMenuBuilder.separator().simpleItem(GuiConstants.RENAME_FILE_TEXT, this::canOperateFolder, this::renameDirectory).simpleItem(GuiConstants.DELETE_FILE_TEXT, this::canOperateFolder, this::deleteDirectory).simpleItem(GuiConstants.OPEN_FILE_TEXT, () -> PackUtil.openPack(this.folderPack)).simpleItem(GuiConstants.OPEN_PARENT_TEXT, () -> PackUtil.openParent(this.folderPack))))), mouseX, mouseY);
    }

    private boolean canOperateFolder() {
        return ObjectsUtil.testNullable((Object)this.folderPack, this.fileOps::isOperable) && PackUtil.validatePackPath(this.folderPack) != null;
    }

    private void renameDirectory() {
        if (this.folderPack != null) {
            this.sendEvent(new FileRenameOpenEvent((PackList)this.root(), this.folderPack));
        }
    }

    private void deleteDirectory() {
        if (this.fileOps.deletePack(this.folderPack)) {
            this.setOpen(false);
            ((FolderPackList)this.root()).remove(this.folderPack);
            this.sendEvent(new FileDeleteEvent((PackList)this.root()));
        }
    }

    public void onRename(class_3288 pack, class_2561 newName) {
        if (this.parent != null && pack == this.folderPack) {
            PackList.Entry entry = this.parent.getEntry(this.folderPack);
            if (entry != null) {
                entry.onRename(newName);
            }
            this.setOpen(false);
        }
    }

    private void sendEvent(PackListEvent event) {
        this.listener.onEvent(event);
    }
}

