/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.pack;

import io.github.fishstiz.fidgetz.util.debounce.ConcurrentPollingDebouncer;
import io.github.fishstiz.fidgetz.util.debounce.PollingDebouncer;
import io.github.fishstiz.packed_packs.PackedPacks;
import io.github.fishstiz.packed_packs.compat.ModAdditions;
import io.github.fishstiz.packed_packs.util.PackUtil;
import java.io.File;
import java.io.FileFilter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_156;
import net.minecraft.class_3264;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;

public class PackWatcher
implements AutoCloseable {
    private static final long POLL_INTERVAL_MS = 1000L;
    private static final long DEBOUNCED_CHANGE_DELAY_MS = 1000L;
    private final FileAlterationMonitor monitor = new FileAlterationMonitor(1000L);
    private final PollingDebouncer<Path> onChangeCallback;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final DirectoryListener directoryListener = new DirectoryListener();
    private long lastPollTime;

    public PackWatcher(class_3264 packType, Collection<Path> directories, Runnable onChangeCallback) {
        this.monitor.setThreadFactory(r -> {
            throw new IllegalStateException("PackWatcher monitor should not be creating a new thread.");
        });
        this.onChangeCallback = new ConcurrentPollingDebouncer(path -> {
            if (!this.closed.get() && !ModAdditions.shouldIgnoreChange(packType, path)) {
                onChangeCallback.run();
            }
        }, 1000L);
        directories.forEach(this::addDirectory);
    }

    private void addDirectory(Path directory) {
        if (!Files.isDirectory(directory, LinkOption.NOFOLLOW_LINKS)) {
            return;
        }
        Path normalizedPath = directory.toAbsolutePath().normalize();
        FileAlterationObserver observer = new FileAlterationObserver(directory.toFile(), (FileFilter)new Filter(normalizedPath), IOCase.SENSITIVE);
        observer.addListener((FileAlterationListener)this.directoryListener);
        class_156.method_18349().execute(() -> {
            if (this.closed.get()) {
                return;
            }
            try {
                observer.initialize();
                if (!this.closed.get()) {
                    this.monitor.addObserver(observer);
                } else {
                    observer.destroy();
                }
            }
            catch (Exception e) {
                PackedPacks.LOGGER.error("[packed_packs] Failed to initialize observer for directory {}.", (Object)normalizedPath, (Object)e);
            }
        });
    }

    public void poll() {
        long currentTime = class_156.method_658();
        if (currentTime - this.lastPollTime >= this.monitor.getInterval()) {
            class_156.method_18349().execute(() -> this.monitor.getObservers().forEach(FileAlterationObserver::checkAndNotify));
            this.lastPollTime = currentTime;
        }
        this.onChangeCallback.poll();
    }

    @Override
    public void close() {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        this.onChangeCallback.abort();
        class_156.method_18349().execute(() -> {
            for (FileAlterationObserver observer : this.monitor.getObservers()) {
                try {
                    observer.destroy();
                }
                catch (Exception e) {
                    PackedPacks.LOGGER.error("[packed_packs] Error occurred while closing observer for {}", (Object)observer.getDirectory(), (Object)e);
                }
            }
        });
    }

    private class DirectoryListener
    extends FileAlterationListenerAdaptor {
        private DirectoryListener() {
        }

        public void onDirectoryCreate(File directory) {
            this.onEvent(directory);
        }

        public void onDirectoryChange(File directory) {
            this.onEvent(directory);
        }

        public void onDirectoryDelete(File directory) {
            this.onEvent(directory);
        }

        public void onFileCreate(File file) {
            this.onEvent(file);
        }

        public void onFileChange(File file) {
            this.onEvent(file);
        }

        public void onFileDelete(File file) {
            this.onEvent(file);
        }

        private void onEvent(File file) {
            PackWatcher.this.onChangeCallback.accept((Object)file.toPath());
        }
    }

    private record Filter(Path root) implements FileFilter
    {
        private static final int DIRECTORY_PACK_DEPTH = 1;
        private static final int PACK_CONTENTS_DEPTH = 2;
        private static final int NESTED_PACK_DEPTH = 3;

        @Override
        public boolean accept(File pathname) {
            Path path = pathname.toPath();
            int depth = this.root.relativize(path.toAbsolutePath().normalize()).getNameCount();
            return switch (depth) {
                case 0, 1 -> true;
                case 2 -> {
                    if (PackUtil.hasMcmeta(path.getParent()) || PackUtil.hasFolderConfig(path.getParent())) {
                        yield true;
                    }
                    yield false;
                }
                case 3 -> PackUtil.hasFolderConfig(path.getParent().getParent());
                default -> false;
            };
        }
    }
}

