/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.util;

import io.github.fishstiz.packed_packs.PackedPacks;
import io.github.fishstiz.packed_packs.transform.interfaces.IPack;
import io.github.fishstiz.packed_packs.transform.mixin.UtilAccess;
import io.github.fishstiz.packed_packs.util.lang.CollectionsUtil;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.fabricmc.fabric.impl.resource.loader.BuiltinModResourcePackSource;
import net.minecraft.class_156;
import net.minecraft.class_310;
import net.minecraft.class_3288;
import net.minecraft.class_5352;
import net.minecraft.class_8581;
import net.minecraft.class_8621;
import net.minecraft.class_9224;
import org.apache.commons.io.FileUtils;

public class PackUtil {
    private static final String FILE_PREFIX = "file/";
    private static final String DELIMITER = "/";

    private PackUtil() {
    }

    public static String fileName(Path path) {
        return path.getFileName().toString();
    }

    public static String generatePackName(Path path) {
        return PackUtil.fileName(path);
    }

    public static String generatePackId(String name) {
        return FILE_PREFIX + name;
    }

    public static String generatePackId(Path path) {
        return PackUtil.generatePackId(PackUtil.generatePackName(path));
    }

    public static String generateNestedPackId(Path path) {
        return FILE_PREFIX + PackUtil.generatePackName(path.getParent()) + DELIMITER + PackUtil.generatePackName(path);
    }

    public static class_9224 replicateLocationInfo(class_9224 info, String id) {
        return new class_9224(id, info.comp_2330(), info.comp_2331(), info.comp_2332());
    }

    public static long getLastUpdatedEpochMs(class_3288 pack) {
        Path path = ((IPack)pack).packed_packs$getPath();
        if (path == null) {
            return -1L;
        }
        try {
            return Files.getLastModifiedTime(path, new LinkOption[0]).toInstant().toEpochMilli();
        }
        catch (IOException e) {
            PackedPacks.LOGGER.error("Failed to get age of pack '{}'", (Object)pack.method_14463());
            return -1L;
        }
    }

    public static List<String> extractPackIds(Collection<class_3288> packs) {
        return CollectionsUtil.extractNonNull(packs, class_3288::method_14463);
    }

    public static String joinPackNames(Collection<Path> paths) {
        return String.join((CharSequence)", ", CollectionsUtil.extractNonNull(paths, PackUtil::generatePackName));
    }

    public static boolean hasMcmeta(Path path) {
        return Files.isRegularFile(path.resolve("pack.mcmeta"), LinkOption.NOFOLLOW_LINKS);
    }

    public static boolean hasFolderConfig(Path path) {
        return Files.isRegularFile(path.resolve("packed_packs.folderpack.json"), LinkOption.NOFOLLOW_LINKS);
    }

    public static boolean isBuiltIn(class_3288 pack) {
        class_5352 packSource = pack.method_29483();
        return packSource == class_5352.field_25348 || packSource instanceof BuiltinModResourcePackSource;
    }

    public static boolean isFeature(class_3288 pack) {
        return pack.method_29483() == class_5352.field_40048;
    }

    public static boolean isNonPackDirectory(Path path) {
        return Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS) && !PackUtil.hasMcmeta(path);
    }

    public static List<Path> mapValidDirectories(List<String> paths) {
        if (paths == null || paths.isEmpty()) {
            return Collections.emptyList();
        }
        return CollectionsUtil.extractNonNull(paths, path -> {
            try {
                Path resolved = Paths.get(path, new String[0]);
                if (Files.exists(resolved, LinkOption.NOFOLLOW_LINKS) && Files.isDirectory(resolved, LinkOption.NOFOLLOW_LINKS)) {
                    return resolved.toAbsolutePath().normalize();
                }
                PackedPacks.LOGGER.error("[packed_packs] Path is not a valid directory: '{}', ignoring.", path);
            }
            catch (Exception e) {
                PackedPacks.LOGGER.error("[packed_packs] Failed to resolve path: '{}', ignoring.", path, (Object)e);
            }
            return null;
        });
    }

    public static void openPack(class_3288 pack) {
        Path path = ((IPack)pack).packed_packs$getPath();
        if (path != null) {
            class_156.method_668().method_60932(path);
        }
    }

    public static void openParent(class_3288 pack) {
        Path path = ((IPack)pack).packed_packs$getPath();
        if (path != null) {
            PackUtil.openParent(path);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void openParent(Path path) {
        File file = path.toFile();
        if (!file.exists()) {
            return;
        }
        try {
            switch (class_156.method_668()) {
                case field_1133: {
                    new ProcessBuilder("explorer.exe", "/select,", file.getAbsolutePath()).start();
                    return;
                }
                case field_1137: {
                    new ProcessBuilder("open", "-R", file.getAbsolutePath()).start();
                    return;
                }
                case field_1135: {
                    File parentFile = file.getParentFile();
                    if (parentFile == null) return;
                    new ProcessBuilder("xdg-open", parentFile.getAbsolutePath()).start();
                    return;
                }
                default: {
                    Path parent = path.getParent();
                    if (parent == null) return;
                    class_156.method_668().method_60932(parent);
                }
            }
            return;
        }
        catch (IOException e) {
            Path parent = path.getParent();
            if (parent == null) return;
            class_156.method_668().method_60932(parent);
        }
    }

    public static boolean deletePath(Path path) {
        com.sun.jna.platform.FileUtils fileUtils = com.sun.jna.platform.FileUtils.getInstance();
        if (fileUtils.hasTrash()) {
            try {
                fileUtils.moveToTrash(new File[]{path.toFile()});
                return true;
            }
            catch (IOException e) {
                PackedPacks.LOGGER.warn("[packed_packs] Failed to move to trash: '{}'", (Object)path, (Object)e);
            }
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            try {
                FileUtils.deleteDirectory((File)path.toFile());
                return true;
            }
            catch (IOException e) {
                PackedPacks.LOGGER.error("[packed_packs] Failed to delete path: '{}'", (Object)path, (Object)e);
                return false;
            }
        }
        return UtilAccess.packed_packs$createDeleter(path).getAsBoolean();
    }

    public static boolean renamePath(Path path, Path newName) {
        return UtilAccess.packed_packs$createRenamer(path, newName).getAsBoolean();
    }

    public static PathValidationResults validatePaths(List<Path> packs) {
        class_8621<Path> packDetector = new class_8621<Path>(class_310.method_1551().method_52702()){

            protected Path createZipPack(Path path) {
                return path;
            }

            protected Path createDirectoryPack(Path path) {
                return path;
            }
        };
        PathValidationResults results = new PathValidationResults(packs);
        block7: for (Path path : packs) {
            try {
                if (!PackUtil.isNonPackDirectory(path)) {
                    if (!PackUtil.validatePath(path, packDetector, results.symlinkWarnings)) continue;
                    results.addValid(path);
                    continue;
                }
                DirectoryStream<Path> paths = Files.newDirectoryStream(path);
                try {
                    for (Path child : paths) {
                        if (!PackUtil.validatePath(child, packDetector, results.symlinkWarnings)) continue;
                        results.addValid(path);
                        continue block7;
                    }
                }
                finally {
                    if (paths == null) continue;
                    paths.close();
                }
            }
            catch (IOException e) {
                PackedPacks.LOGGER.warn("Failed to check {} for packs", (Object)path, (Object)e);
            }
        }
        return results;
    }

    private static boolean validatePath(Path path, class_8621<Path> packDetector, List<class_8581> symlinkWarnings) throws IOException {
        Path detectedPack = (Path)packDetector.method_52441(path, symlinkWarnings);
        if (detectedPack == null) {
            PackedPacks.LOGGER.warn("Path {} does not seem like pack", (Object)path);
            return false;
        }
        return true;
    }

    public record PathValidationResults(List<Path> valid, Set<Path> rejected, List<class_8581> symlinkWarnings) {
        private PathValidationResults(Collection<Path> packs) {
            this(new ArrayList<Path>(packs.size()), (Set<Path>)new ObjectOpenHashSet(packs), new ArrayList<class_8581>());
        }

        private void addValid(Path path) {
            this.valid.add(path);
            this.rejected.remove(path);
        }
    }
}

