package io.github.fishstiz.fidgetz.gui.components;

import io.github.fishstiz.fidgetz.gui.Metadata;
import io.github.fishstiz.fidgetz.gui.renderables.RenderableRect;
import java.util.Objects;
import net.minecraft.class_1144;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_5244;
import net.minecraft.class_6382;

public class RenderableRectWidget<E> extends class_339 implements Metadata<E>, Fidgetz {
    protected RenderableRect renderableRect;
    protected E metadata;

    protected RenderableRectWidget(Builder<E> builder) {
        super(builder.x, builder.y, builder.width, builder.height, class_5244.field_39003);
        this.renderableRect = builder.renderableRect;
        this.metadata = builder.metadata;
    }

    @Override
    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.field_22762 = this.field_22762 && Fidgetz.super.isHovered(mouseX, mouseY);
        this.renderableRect.render(guiGraphics, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), partialTick);
    }

    public void setRenderableRect(RenderableRect renderableRect) {
        this.renderableRect = Objects.requireNonNull(renderableRect, "RenderableRect");
    }

    @Override
    public boolean method_25405(double mouseX, double mouseY) {
        return this.field_22763 && Fidgetz.super.method_25405(mouseX, mouseY);
    }

    @Override
    protected void method_47399(class_6382 narrationElementOutput) {
    }

    @Override
    public void method_25354(class_1144 handler) {
    }

    @Override
    public E getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(E metadata) {
        this.metadata = metadata;
    }

    public static <E> Builder<E> builder(RenderableRect renderableRect) {
        return new Builder<>(renderableRect);
    }

    public static class Builder<E> extends AbstractWidgetBuilder<Builder<E>> {
        protected final RenderableRect renderableRect;
        protected E metadata;

        protected Builder(RenderableRect renderableRect) {
            this.renderableRect = renderableRect;
        }

        public Builder<E> setMetadata(E metadata) {
            this.metadata = metadata;
            return this.self();
        }

        public RenderableRectWidget<E> build() {
            return new RenderableRectWidget<>(this);
        }
    }
}
