package io.github.fishstiz.fidgetz.util.text;

import org.jetbrains.annotations.Nullable;

import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2583;

public class PatternStylizer implements TextStylizer {
    private final @Nullable Predicate<String> canStylize;
    private final Matcher matcher;
    private final class_2583 style;

    public PatternStylizer(@Nullable Predicate<String> canStylize, Pattern pattern, class_2583 style) {
        this.canStylize = canStylize;
        this.matcher = pattern.matcher("");
        this.style = style;
    }

    public PatternStylizer(@Nullable Predicate<String> canStylize, Pattern pattern, int color) {
        this(canStylize, pattern, class_2583.field_24360.method_36139(color));
    }

    @Override
    public boolean canStylize(String input) {
        return this.canStylize == null || this.canStylize.test(input);
    }

    @Override
    public void reset(String input) {
        this.matcher.reset(input);
    }

    @Override
    public boolean find() {
        return this.matcher.find();
    }

    @Override
    public int start() {
        return this.matcher.start();
    }

    @Override
    public int end() {
        return this.matcher.end();
    }

    @Override
    public class_2583 style() {
        return this.matcher.hasMatch() ? this.style : class_2583.field_24360;
    }

    @Override
    public TextStylizer copy() {
        return new PatternStylizer(this.canStylize, this.matcher.pattern(), this.style);
    }
}
