package io.github.fishstiz.packed_packs.transform.mixin.folders.additional;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import io.github.fishstiz.packed_packs.config.Config;
import io.github.fishstiz.packed_packs.util.PackUtil;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3279;
import net.minecraft.class_3283;
import net.minecraft.class_3285;
import net.minecraft.class_525;
import org.apache.commons.lang3.ArrayUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_525.class)
public abstract class CreateWorldScreenMixin {
    @WrapOperation(method = "openCreateWorldScreen", at = @At(
            value = "NEW",
            target = "([Lnet/minecraft/server/packs/repository/RepositorySource;)Lnet/minecraft/server/packs/repository/PackRepository;"
    ))
    private static class_3283 addAdditionalFolders(
            class_3285[] sources,
            Operation<class_3283> original,
            class_310 minecraft
    ) {
        class_3285[] folders = PackUtil.mapValidDirectories(Config.get().getDatapacks().getAdditionalFolders())
                .stream()
                .map(path -> path.toAbsolutePath().normalize())
                .distinct()
                .map(path -> new class_3279(path, class_3264.field_14190, PackUtil.PACK_SOURCE, minecraft.method_52702()))
                .toArray(class_3285[]::new);

        return original.call((Object) ArrayUtils.addAll(sources, folders));
    }
}
