/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.config;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.github.fishstiz.packed_packs.PackedPacks;
import io.github.fishstiz.packed_packs.config.ConfigFixer;
import io.github.fishstiz.packed_packs.config.PackOverride;
import io.github.fishstiz.packed_packs.config.Profile;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Supplier;

public class JsonLoader {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(PackOverride.class, (Object)new PackOverride.Adapter()).registerTypeAdapter(Profile.class, (Object)new Profile.Deserializer()).addSerializationExclusionStrategy((ExclusionStrategy)new ConfigFixer.ProfileExclusionStrategy()).create();

    private JsonLoader() {
    }

    public static <T extends Serializable> T loadJson(InputStream inputStream, Class<T> clazz) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(inputStream);){
            Serializable serializable = (Serializable)GSON.fromJson((Reader)reader, clazz);
            return (T)serializable;
        }
    }

    public static <T extends Serializable> T loadJsonOrDefault(Path path, Class<T> clazz, Supplier<T> defaultFactory) {
        try {
            byte[] bytes = Files.readAllBytes(path);
            return (T)((Serializable)GSON.fromJson(new String(bytes, StandardCharsets.UTF_8), clazz));
        }
        catch (NoSuchFileException bytes) {
        }
        catch (IOException e) {
            PackedPacks.LOGGER.error("[packed_packs] Failed to load file at '{}'. ", (Object)path, (Object)e);
        }
        return (T)((Serializable)defaultFactory.get());
    }

    public static <T extends Serializable> T loadOrCreateJson(Path path, Class<T> clazz, Supplier<T> defaultFactory) {
        try {
            byte[] bytes = Files.readAllBytes(path);
            String json = new String(bytes, StandardCharsets.UTF_8);
            return (T)((Serializable)GSON.fromJson(json, clazz));
        }
        catch (NoSuchFileException e) {
            Serializable serializable = (Serializable)defaultFactory.get();
            PackedPacks.LOGGER.info("[packed_packs] Creating file at '{}'.", (Object)path);
            JsonLoader.saveJson(serializable, path);
            return (T)serializable;
        }
        catch (IOException e) {
            PackedPacks.LOGGER.error("[packed_packs] Failed to load file at '{}'. ", (Object)path, (Object)e);
            return (T)((Serializable)defaultFactory.get());
        }
    }

    public static <T extends Serializable> void saveJson(T serializable, Path path) {
        try {
            String json = GSON.toJson(serializable);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.writeString(path, (CharSequence)json, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            PackedPacks.LOGGER.info("[packed_packs] Failed to save file at '{}'.", (Object)path);
        }
    }
}

