/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.gui.components.pack;

import io.github.fishstiz.fidgetz.gui.components.CyclicButton;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.ButtonSprites;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.Sprite;
import io.github.fishstiz.fidgetz.gui.shapes.Size;
import io.github.fishstiz.packed_packs.pack.folder.FolderPack;
import io.github.fishstiz.packed_packs.util.PackUtil;
import io.github.fishstiz.packed_packs.util.ResourceUtil;
import java.util.Comparator;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_2561;
import net.minecraft.class_3288;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record Query(boolean hideIncompatible, SortOption sort, String search, String unmodifiedSearch) implements Predicate<class_3288>,
Comparator<class_3288>
{
    public Query {
        search = search != null ? search.toLowerCase(Locale.ROOT) : null;
    }

    public Query(Query query) {
        this(query.hideIncompatible, query.sort, query.search, query.unmodifiedSearch);
    }

    Query() {
        this(false, null, null, null);
    }

    public Query withHideIncompatible(boolean hideIncompatible) {
        if (this.hideIncompatible == hideIncompatible) {
            return this;
        }
        return new Query(hideIncompatible, this.sort, this.search, this.unmodifiedSearch);
    }

    public Query withSort(SortOption sort) {
        if (Objects.equals(this.sort, sort)) {
            return this;
        }
        return new Query(this.hideIncompatible, sort, this.search, this.unmodifiedSearch);
    }

    public Query withSearch(String search) {
        String searchLower;
        String string = searchLower = search != null ? search.toLowerCase(Locale.ROOT) : null;
        if (Objects.equals(this.search, searchLower)) {
            return this;
        }
        return new Query(this.hideIncompatible, this.sort, searchLower, search);
    }

    @Override
    public boolean test(class_3288 pack) {
        if (pack == null) {
            return false;
        }
        if (this.hideIncompatible && !pack.method_14460().method_14437()) {
            return false;
        }
        return this.search == null || Query.normalizeTitle(pack.method_14457().getString()).toLowerCase(Locale.ROOT).contains(this.search);
    }

    @Override
    public int compare(class_3288 first, class_3288 second) {
        return this.sort != null ? this.sort.comparator.compare(first, second) : 0;
    }

    boolean hasQuery() {
        return this.hideIncompatible || this.search != null && !this.search.isEmpty() || this.sort != null;
    }

    private static String normalizeTitle(String title) {
        return title.replaceAll("\u00a7.", "").trim();
    }

    public static enum SortOption implements CyclicButton.SpriteOption
    {
        VANILLA("sort.vanilla", "sort_vanilla", (first, second) -> {
            boolean featureSecond;
            boolean builtInSecond;
            boolean builtInFirst = PackUtil.isBuiltIn(first);
            if (builtInFirst != (builtInSecond = PackUtil.isBuiltIn(second))) {
                return builtInFirst ? 1 : -1;
            }
            boolean featureFirst = PackUtil.isFeature(first);
            if (featureFirst != (featureSecond = PackUtil.isFeature(second))) {
                return featureFirst ? 1 : -1;
            }
            return first.method_14457().getString().compareTo(second.method_14457().getString());
        }),
        A_Z("sort.a_z", "sort_a_z", Comparator.comparing(pack -> Query.normalizeTitle(pack.method_14457().getString()), String.CASE_INSENSITIVE_ORDER)),
        Z_A("sort.z_a", "sort_z_a", SortOption.A_Z.comparator.reversed()),
        RECENT("sort.recent", "sort_recent", Comparator.comparingLong(PackUtil::getLastUpdatedEpochMs).reversed()),
        OLDEST("sort.oldest", "sort_oldest", SortOption.RECENT.comparator.reversed());

        private final class_2561 component;
        private final class_7919 tooltip;
        private final ButtonSprites sprites;
        private final Comparator<class_3288> comparator;

        private SortOption(String key, String icon, Comparator<class_3288> comparator) {
            this.component = ResourceUtil.getText(key, new Object[0]);
            this.tooltip = class_7919.method_47407((class_2561)this.component);
            this.sprites = ButtonSprites.of(new Sprite(ResourceUtil.getIcon(icon), Size.of16()));
            this.comparator = SortOption.folderFirst(comparator);
        }

        @Override
        @NotNull
        public class_2561 text() {
            return this.component;
        }

        @Override
        @Nullable
        public class_7919 tooltip() {
            return this.tooltip;
        }

        @Override
        @Nullable
        public ButtonSprites sprites() {
            return this.sprites;
        }

        static Comparator<class_3288> folderFirst(Comparator<class_3288> base) {
            return Comparator.comparing(pack -> !(pack instanceof FolderPack)).thenComparing(base);
        }

        public static SortOption getOrDefault(String name) {
            if (name == null) {
                return VANILLA;
            }
            try {
                return SortOption.valueOf(name);
            }
            catch (IllegalArgumentException e) {
                return VANILLA;
            }
        }
    }
}

