package io.github.fishstiz.packed_packs.pack;

import com.google.common.hash.Hashing;
import io.github.fishstiz.packed_packs.PackedPacks;
import io.github.fishstiz.packed_packs.pack.folder.FolderPack;
import io.github.fishstiz.packed_packs.util.PackUtil;
import io.github.fishstiz.packed_packs.util.ResourceUtil;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.InputStream;
import java.nio.file.NoSuchFileException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1060;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3262;
import net.minecraft.class_3288;
import net.minecraft.class_5375;
import net.minecraft.class_7367;

public class PackAssetManager {
    public static final class_2960 DEFAULT_FOLDER_ICON = ResourceUtil.getResource("textures/misc/unknown_folder.png");
    public static final class_2960 DEFAULT_ICON = class_2960.method_60656("textures/misc/unknown_pack.png");
    private final Map<String, class_2960> cachedIcons = new Object2ObjectOpenHashMap<>();
    private final class_310 minecraft;
    private Map<String, class_2960> staleIcons;

    public PackAssetManager(class_310 minecraft) {
        this.minecraft = minecraft;
    }

    public class_2960 getIcon(class_3288 pack) {
        return this.cachedIcons.getOrDefault(pack.method_14463(), this.staleIcons != null
                ? this.staleIcons.getOrDefault(pack.method_14463(), getDefaultIcon(pack))
                : getDefaultIcon(pack)
        );
    }

    public void getOrLoadIcon(class_3288 pack, Consumer<class_2960> iconCallback) {
        if (this.staleIcons != null) {
            class_2960 staleIcon = this.staleIcons.get(pack.method_14463());
            if (staleIcon != null) {
                iconCallback.accept(staleIcon);
            }
        }

        class_2960 cachedIcon = this.cachedIcons.get(pack.method_14463());
        if (cachedIcon != null) {
            iconCallback.accept(cachedIcon);
        } else {
            this.loadPackIcon(pack).thenAcceptAsync(location -> {
                this.cachedIcons.put(pack.method_14463(), location);
                iconCallback.accept(location);
            }, this.minecraft);
        }
    }

    public void clearIconCache() {
        this.staleIcons = new Object2ObjectOpenHashMap<>(this.cachedIcons);
        this.cachedIcons.clear();
    }

    public static class_2960 getDefaultIcon(class_3288 pack) {
        return pack instanceof FolderPack ? DEFAULT_FOLDER_ICON : DEFAULT_ICON;
    }

    /**
     * Copied from {@link class_5375#method_30289(class_1060, class_3288)}
     */
    private CompletableFuture<class_2960> loadPackIcon(class_3288 pack) {
        return CompletableFuture.supplyAsync(() -> {
            try (class_3262 packResources = pack.method_14458()) {
                class_7367<InputStream> iconIoSupplier = packResources.method_14410(PackUtil.ICON_FILENAME);
                if (iconIoSupplier == null) return getDefaultIcon(pack);

                class_2960 icon = class_2960.method_60656(hashIconName(pack.method_14463()));

                try (InputStream iconStream = iconIoSupplier.get()) {
                    class_1011 nativeImage = class_1011.method_4309(iconStream);
                    class_1060 manager = this.minecraft.method_1531();
                    this.minecraft.execute(() -> manager.method_4616(icon, new class_1043(nativeImage)));
                    return icon;
                }
            } catch (Exception e) {
                if (!(e instanceof NoSuchFileException)) {
                    PackedPacks.LOGGER.warn("Failed to load icon from pack '{}'", pack.method_14463(), e);
                }
                return getDefaultIcon(pack);
            }
        }, class_156.method_18349());
    }

    private static String hashIconName(String id) {
        return "pack/" + class_156.method_30309(id, class_2960::method_29184) + "/" + Hashing.sha1().hashUnencodedChars(id) + "/icon";
    }
}
