/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.compat;

import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuItemBuilder;
import io.github.fishstiz.fidgetz.gui.layouts.FlexLayout;
import io.github.fishstiz.packed_packs.PackedPacks;
import io.github.fishstiz.packed_packs.compat.api.ModExtension;
import io.github.fishstiz.packed_packs.gui.components.pack.PackList;
import io.github.fishstiz.packed_packs.util.lang.CollectionsUtil;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3264;
import net.minecraft.class_5375;
import org.jetbrains.annotations.Nullable;

public class ModAdditions {
    private static final List<ModExtension> EXTENSIONS;

    private ModAdditions() {
    }

    public static void onCreateHeader(class_3264 packType, FlexLayout header, class_5375 original) {
        for (ModExtension ext : EXTENSIONS) {
            try {
                ext.onCreateHeader(packType, header, original);
            }
            catch (Exception e) {
                PackedPacks.LOGGER.error("[packed_packs] Error while creating header from extension {} ", (Object)ext.id(), (Object)e);
            }
        }
    }

    public static void onCreateEntry(class_3264 packType, PackList.Entry entry) {
        for (ModExtension ext : EXTENSIONS) {
            try {
                ext.onCreateEntry(packType, entry);
            }
            catch (Exception e) {
                PackedPacks.LOGGER.error("[packed_packs] Error while creating entry for pack {} from extension {} ", new Object[]{entry.pack().method_14463(), ext.id(), e});
            }
        }
    }

    public static void onCreatePreferencesMenu(class_3264 packType, ContextMenuItemBuilder contextMenuItemBuilder) {
        for (ModExtension ext : EXTENSIONS) {
            try {
                ext.onCreatePreferencesMenu(packType, contextMenuItemBuilder);
            }
            catch (Exception e) {
                PackedPacks.LOGGER.error("[packed_packs] Error while building context menu from extension {} ", (Object)ext.id(), (Object)e);
            }
        }
    }

    @Nullable
    public static String forceCommitOnClose(class_3264 packType) {
        for (ModExtension ext : EXTENSIONS) {
            try {
                if (!ext.forceCommitOnClose(packType)) continue;
                return ext.id().toString();
            }
            catch (Exception e) {
                PackedPacks.LOGGER.error("[packed_packs] Error while closing screen from extension {} ", (Object)ext.id(), (Object)e);
            }
        }
        return null;
    }

    public static boolean shouldIgnoreChange(class_3264 packType, Path path) {
        for (ModExtension ext : EXTENSIONS) {
            try {
                if (!ext.shouldIgnoreChange(packType, path)) continue;
                return true;
            }
            catch (Exception e) {
                PackedPacks.LOGGER.error("[packed_packs] Error while detecting file change from extension {} ", (Object)ext.id(), (Object)e);
            }
        }
        return false;
    }

    static {
        List extensions = FabricLoader.getInstance().getEntrypoints("packed_packs", ModExtension.class);
        EXTENSIONS = extensions.isEmpty() ? Collections.emptyList() : CollectionsUtil.topoSort(extensions, ModExtension::id, ModExtension::loadAfter);
    }
}

