/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.config;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.github.fishstiz.packed_packs.PackedPacks;
import io.github.fishstiz.packed_packs.transform.interfaces.ConfiguredPack;
import java.io.Serializable;
import java.lang.reflect.Type;
import net.minecraft.class_3288;
import org.jetbrains.annotations.Nullable;

public final class PackOverride
implements Serializable {
    @Deprecated(forRemoval=true)
    private static final String FIXED_DEPRECATED_SERIALIZED_NAME = "fixed";
    private static final String HIDDEN_SERIALIZED_NAME = "hidden";
    private static final String REQUIRED_SERIALIZED_NAME = "required";
    private static final String POSITION_SERIALIZED_NAME = "position";
    @Nullable
    private Boolean hidden;
    @Nullable
    private Boolean required;
    @Nullable
    private Position position;

    public PackOverride() {
    }

    public PackOverride(@Nullable Boolean hidden, @Nullable Boolean required, @Nullable Position position) {
        this.hidden = hidden;
        this.required = required;
        this.position = position;
    }

    public boolean hasOverride() {
        return Boolean.TRUE.equals(this.hidden) || this.required != null || this.position != null;
    }

    @Nullable
    public Boolean hidden() {
        return this.hidden;
    }

    void setHidden(@Nullable Boolean hidden) {
        this.hidden = hidden;
    }

    @Nullable
    public Boolean required() {
        return this.required;
    }

    void setRequired(@Nullable Boolean required) {
        this.required = required;
    }

    @Nullable
    public Position position() {
        return this.position;
    }

    void setPosition(@Nullable Position position) {
        this.position = position;
    }

    public static enum Position {
        UNFIXED(null),
        TOP(class_3288.class_3289.field_14280),
        BOTTOM(class_3288.class_3289.field_14281);

        private final class_3288.class_3289 position;

        private Position(class_3288.class_3289 position) {
            this.position = position;
        }

        public boolean fixed() {
            return this != UNFIXED;
        }

        class_3288.class_3289 get(class_3288 pack) {
            return this.fixed() ? this.position : ((ConfiguredPack)pack).packed_packs$originalConfig().comp_2334();
        }
    }

    static class Adapter
    implements JsonSerializer<PackOverride>,
    JsonDeserializer<PackOverride> {
        Adapter() {
        }

        public JsonElement serialize(PackOverride src, Type typeOfSrc, JsonSerializationContext context) {
            if (!src.hasOverride()) {
                return null;
            }
            JsonObject obj = new JsonObject();
            if (src.hidden() != null) {
                obj.addProperty(PackOverride.HIDDEN_SERIALIZED_NAME, src.hidden());
            }
            if (src.required() != null) {
                obj.addProperty(PackOverride.REQUIRED_SERIALIZED_NAME, src.required());
            }
            if (src.position() != null) {
                obj.addProperty(PackOverride.POSITION_SERIALIZED_NAME, src.position().name());
            }
            return obj;
        }

        public PackOverride deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            Boolean hidden = obj.has(PackOverride.HIDDEN_SERIALIZED_NAME) ? Boolean.valueOf(obj.get(PackOverride.HIDDEN_SERIALIZED_NAME).getAsBoolean()) : null;
            Boolean required = obj.has(PackOverride.REQUIRED_SERIALIZED_NAME) ? Boolean.valueOf(obj.get(PackOverride.REQUIRED_SERIALIZED_NAME).getAsBoolean()) : null;
            Position fixed = null;
            if (obj.has(PackOverride.POSITION_SERIALIZED_NAME) || obj.has(PackOverride.FIXED_DEPRECATED_SERIALIZED_NAME)) {
                String position = obj.has(PackOverride.POSITION_SERIALIZED_NAME) ? obj.get(PackOverride.POSITION_SERIALIZED_NAME).getAsString() : obj.get(PackOverride.FIXED_DEPRECATED_SERIALIZED_NAME).getAsString();
                try {
                    fixed = Position.valueOf(position.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    PackedPacks.LOGGER.error("[packed_packs] Invalid value for key 'position': '{}'. Expected one of {}", (Object)position, (Object)Position.values());
                }
            }
            return new PackOverride(hidden, required, fixed);
        }
    }
}

