/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.gui.components.pack;

import io.github.fishstiz.fidgetz.gui.renderables.ColoredRect;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.Sprite;
import io.github.fishstiz.fidgetz.util.GuiUtil;
import io.github.fishstiz.packed_packs.gui.components.SelectionContext;
import io.github.fishstiz.packed_packs.gui.components.events.DragEvent;
import io.github.fishstiz.packed_packs.gui.components.events.PackListEventListener;
import io.github.fishstiz.packed_packs.gui.components.pack.PackList;
import io.github.fishstiz.packed_packs.gui.components.pack.PackListDevMenu;
import io.github.fishstiz.packed_packs.pack.PackAssetManager;
import io.github.fishstiz.packed_packs.pack.PackFileOperations;
import io.github.fishstiz.packed_packs.pack.PackOptionsContext;
import io.github.fishstiz.packed_packs.util.InputUtil;
import io.github.fishstiz.packed_packs.util.ResourceUtil;
import io.github.fishstiz.packed_packs.util.constants.GuiConstants;
import io.github.fishstiz.packed_packs.util.constants.Theme;
import io.github.fishstiz.packed_packs.util.lang.ObjectsUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_3288;
import net.minecraft.class_332;
import net.minecraft.class_350;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AvailablePackList
extends PackList {
    private static final Sprite SELECT_HIGHLIGHTED_SPRITE = Sprite.of32(ResourceUtil.getVanillaSprite("transferable_list/select_highlighted"));
    private static final Sprite SELECT_SPRITE = Sprite.of32(ResourceUtil.getVanillaSprite("transferable_list/select"));
    private static final Theme DROP_ZONE_THEME = Theme.RED_700;
    private static final ColoredRect DROP_ZONE = new ColoredRect(DROP_ZONE_THEME.withAlpha(0.25f));

    public AvailablePackList(PackOptionsContext options, PackAssetManager assets, PackFileOperations fileOps, PackListEventListener listener) {
        super(options, assets, fileOps, listener);
    }

    @Override
    @NotNull
    protected Entry createEntry(SelectionContext<class_3288> context, int index) {
        return new Entry(context, index);
    }

    @Override
    public boolean canInteract(PackList source) {
        return source != this;
    }

    private boolean isInvalidDrop(PackList source, List<class_3288> payload, class_3288 trigger) {
        return !source.canInteract(this) || payload.isEmpty() || !source.isTransferable(trigger);
    }

    @Override
    public boolean canDrop(DragEvent dragEvent, double mouseX, double mouseY) {
        return this.method_25405(mouseX, mouseY) && !this.isInvalidDrop(dragEvent.target(), dragEvent.payload(), dragEvent.trigger());
    }

    @Override
    protected List<class_3288> handleDrop(DragEvent dragEvent, double mouseX, double mouseY) {
        class_3288 trigger;
        List<class_3288> payload;
        PackList source = dragEvent.target();
        if (this.isInvalidDrop(source, payload = dragEvent.payload(), trigger = dragEvent.trigger())) {
            return Collections.emptyList();
        }
        ArrayList<class_3288> dropped = new ArrayList<class_3288>();
        for (class_3288 pack : payload) {
            if (!source.isTransferable(pack)) continue;
            dropped.add(pack);
        }
        this.clearSelection();
        source.removeAll(dropped);
        this.addAll(dropped);
        this.selectAll(dropped);
        this.select(trigger);
        ObjectsUtil.ifPresent(this.getEntry(trigger), x$0 -> this.method_25328((class_350.class_351)x$0));
        return dropped;
    }

    @Override
    public void renderDroppableZone(class_332 guiGraphics, DragEvent dragEvent, int mouseX, int mouseY, float partialTick) {
        int width;
        class_3288 trigger;
        List<class_3288> payload;
        PackList source = dragEvent.target();
        if (this.isInvalidDrop(source, payload = dragEvent.payload(), trigger = dragEvent.trigger())) {
            return;
        }
        int n = width = this.method_44392() ? this.method_25368() - this.scrollbarOffset : this.method_25368();
        if (this.method_25405(mouseX, mouseY)) {
            DROP_ZONE.render(guiGraphics, this.method_46426(), this.method_46427(), width, this.method_25364(), partialTick);
        }
        guiGraphics.method_49601(this.method_46426(), this.method_46427(), width, this.method_25364(), DROP_ZONE_THEME.getARGB());
    }

    public class Entry
    extends PackList.Entry {
        private Entry(SelectionContext<class_3288> context, int index) {
            super(AvailablePackList.this, context, index);
        }

        @Override
        @Nullable
        protected PackListDevMenu createDevMenu(PackOptionsContext options, SelectionContext<class_3288> context) {
            return new PackListDevMenu(options, context, event -> {
                List<class_3288> patt3$temp;
                Boolean patt2$temp;
                class_3288 trigger;
                if (!(event instanceof PackListDevMenu.Event.Require)) return;
                PackListDevMenu.Event.Require $b$0 = (PackListDevMenu.Event.Require)event;
                try {
                    class_3288 patt1$temp;
                    trigger = patt1$temp = $b$0.trigger();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                Boolean value = patt2$temp = $b$0.value();
                List<class_3288> required = patt3$temp = $b$0.packs();
                if (!Boolean.TRUE.equals(value)) return;
                this.sendPacks(trigger, required);
            });
        }

        public boolean isMouseOverSelect(double mouseX, double mouseY) {
            return AvailablePackList.this.method_49606() && GuiUtil.containsPoint(this.method_46426() + 2, this.method_46427(), AvailablePackList.SELECT_SPRITE.width, AvailablePackList.SELECT_SPRITE.height, mouseX, mouseY);
        }

        @Override
        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (InputUtil.isLeftClick(button) && this.isMouseOverSelect(mouseX, mouseY)) {
                GuiUtil.playClickSound();
                this.transfer();
                return false;
            }
            return super.method_25402(mouseX, mouseY, button);
        }

        @Override
        protected void renderForeground(class_332 guiGraphics, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            if (!hovering && !this.isSelectedLast()) {
                return;
            }
            int x = left + 2;
            GuiConstants.WHITE_OVERLAY.render(guiGraphics, x, top, AvailablePackList.SELECT_SPRITE.width, AvailablePackList.SELECT_SPRITE.height);
            if (this.isTransferable()) {
                ObjectsUtil.pick(!this.isMouseOverSelect(mouseX, mouseY), SELECT_SPRITE, SELECT_HIGHLIGHTED_SPRITE).render(guiGraphics, x, top);
            }
        }
    }
}

