/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.gui.components.pack;

import io.github.fishstiz.fidgetz.gui.components.FidgetzButton;
import io.github.fishstiz.fidgetz.gui.components.FidgetzText;
import io.github.fishstiz.fidgetz.gui.components.LayoutWrapper;
import io.github.fishstiz.fidgetz.gui.components.Modal;
import io.github.fishstiz.fidgetz.gui.components.ToggleableEditBox;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.Sprite;
import io.github.fishstiz.fidgetz.util.DrawUtil;
import io.github.fishstiz.packed_packs.gui.components.events.FileRenameCloseEvent;
import io.github.fishstiz.packed_packs.gui.components.events.FileRenameEvent;
import io.github.fishstiz.packed_packs.gui.components.events.PackListEventListener;
import io.github.fishstiz.packed_packs.gui.components.pack.PackList;
import io.github.fishstiz.packed_packs.pack.PackAssetManager;
import io.github.fishstiz.packed_packs.pack.PackFileOperations;
import io.github.fishstiz.packed_packs.util.PackUtil;
import io.github.fishstiz.packed_packs.util.ToastUtil;
import java.util.Objects;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import net.minecraft.class_3288;
import net.minecraft.class_332;
import net.minecraft.class_4069;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_7847;
import net.minecraft.class_8016;
import net.minecraft.class_8021;
import net.minecraft.class_8023;
import net.minecraft.class_8027;
import net.minecraft.class_8028;
import net.minecraft.class_8667;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileRenameModal
extends Modal<class_8667> {
    private static final int MAX_LENGTH = 255;
    private static final int CONTENT_WIDTH = 200;
    private static final int SHADOW_SIZE = 24;
    private static final int TITLE_HEIGHT = 16;
    private static final Pattern ILLEGAL_CHAR_PATTERN = Pattern.compile(".*[<>:\"/\\\\|?*].*");
    private static final Sprite DEFAULT_SPRITE = Sprite.of16(PackAssetManager.DEFAULT_ICON);
    private final ToggleableEditBox<Void> nameEditor = ToggleableEditBox.builder().setEditable(true).addListener(this::handleChange).setMaxLength(255).setFilter(this::testInput).build();
    private final FidgetzText<Void> title = ((FidgetzText.Builder)FidgetzText.builder().alignLeft().setHeight(16)).setOffsetY(1).setShadow(true).build();
    private final FidgetzButton<Void> saveButton = ((FidgetzButton.Builder)((FidgetzButton.Builder)FidgetzButton.builder().setOnPress(this::saveName)).setMessage(class_5244.field_24334)).build();
    private final PackFileOperations fileOps;
    private final PackAssetManager assets;
    private Sprite sprite = DEFAULT_SPRITE;
    private PackList packList;
    private class_3288 pack;
    private String oldName;

    public <S extends class_437 & PackListEventListener> FileRenameModal(S screen, PackFileOperations fileOps, PackAssetManager assets) {
        super(Modal.builder(screen, class_8667.method_52741()));
        this.fileOps = fileOps;
        this.assets = assets;
        class_7847 rootLayoutSettings = class_7847.method_46481().method_46477(8).method_46471(8);
        ((class_8667)((LayoutWrapper)((Object)this.root())).layout()).method_52737(this.title, rootLayoutSettings);
        ((class_8667)((LayoutWrapper)((Object)this.root())).layout()).method_52737(this.nameEditor, rootLayoutSettings);
        FidgetzButton cancelButton = ((FidgetzButton.Builder)((FidgetzButton.Builder)FidgetzButton.builder().setOnPress(() -> this.setOpen(false))).setMessage(class_5244.field_24335)).build();
        class_8667 buttonLayout = class_8667.method_52742();
        buttonLayout.method_52737(cancelButton, class_7847.method_46481().method_46477(8));
        buttonLayout.method_52736(this.saveButton);
        ((class_8667)((LayoutWrapper)((Object)this.root())).layout()).method_52737((class_8021)buttonLayout, class_7847.method_46481().method_46471(8).method_46475(12));
        ((class_8667)((LayoutWrapper)((Object)this.root())).layout()).method_48206(widget -> widget.method_25358(200));
        buttonLayout.method_48206(widget -> widget.method_25358(96));
        ((LayoutWrapper)((Object)this.root())).method_48222();
        ((LayoutWrapper)((Object)this.root())).method_48206(this::addRenderableWidget);
        this.addListener(this::onClose);
    }

    @Override
    public void repositionElements() {
        this.title.method_25358(this.title.method_25368() - this.sprite.width - 8);
        super.repositionElements();
        this.title.method_46421(this.title.method_46426() + this.sprite.width + 8);
    }

    private void clearReferences() {
        this.packList = null;
        this.pack = null;
        this.oldName = null;
        this.sprite = DEFAULT_SPRITE;
        this.title.method_25355(class_5244.field_39003);
        this.nameEditor.method_1852("");
    }

    public void open(PackList packList, class_3288 pack) {
        this.packList = packList;
        this.pack = pack;
        this.sprite = Sprite.of16(PackAssetManager.getDefaultIcon(pack));
        this.assets.getOrLoadIcon(pack, icon -> {
            this.sprite = Sprite.of16(icon);
        });
        this.title.method_25355(pack.method_14457());
        this.oldName = FileRenameModal.sanitizeNameForEdit(pack);
        this.nameEditor.method_1852(this.oldName);
        this.nameEditor.method_1887(PackUtil.isZipPack(pack) ? ".zip" : null);
        this.saveButton.field_22763 = false;
        this.setOpen(true);
    }

    private boolean testInput(String input) {
        if (input == null || !input.isEmpty() && input.isBlank()) {
            return false;
        }
        return FileRenameModal.testIllegalChars(input);
    }

    private boolean canSave(String input) {
        if (input == null || input.isBlank()) {
            return false;
        }
        if (this.pack == null || PackUtil.validatePackPath(this.pack) == null) {
            return false;
        }
        String trimmed = input.trim();
        if (Objects.equals(this.oldName, trimmed)) {
            return false;
        }
        return FileRenameModal.testIllegalChars(input);
    }

    private void handleChange(String name) {
        this.saveButton.field_22763 = this.canSave(name);
    }

    private void onClose(boolean open) {
        if (open) {
            return;
        }
        PackList target = this.packList;
        class_3288 trigger = this.pack;
        if (target != null) {
            ((PackListEventListener)this.screen).onEvent(new FileRenameCloseEvent(target, trigger));
        }
        this.clearReferences();
    }

    private void saveName() {
        String newName = this.nameEditor.method_1882();
        if (!this.canSave(newName)) {
            return;
        }
        String sanitizedName = FileRenameModal.sanitizeNameForSave(this.pack, newName);
        if (this.fileOps.renamePack(this.pack, sanitizedName)) {
            PackList.Entry entry;
            class_5250 sanitizedNameText = class_2561.method_43470((String)sanitizedName);
            if (this.packList != null && (entry = this.packList.getEntry(this.pack)) != null) {
                entry.onRename((class_2561)sanitizedNameText);
            }
            ((PackListEventListener)this.screen).onEvent(new FileRenameEvent(this.packList, this.pack, (class_2561)sanitizedNameText));
            this.setOpen(false);
            this.clearReferences();
        } else {
            ToastUtil.onFileFailToast(ToastUtil.getRenameFailText(this.pack.method_14457().getString(), newName));
        }
    }

    private static String sanitizeNameForEdit(class_3288 pack) {
        String name = pack.method_14457().getString();
        return PackUtil.isZipPack(pack) ? name.replaceFirst(Pattern.quote(".zip") + "$", "") : name;
    }

    private static String sanitizeNameForSave(class_3288 pack, String newName) {
        newName = FilenameUtils.getName((String)newName).trim();
        return PackUtil.isZipPack(pack) ? newName + ".zip" : newName;
    }

    private static boolean testIllegalChars(@NotNull String input) {
        if (!(input = input.trim()).equals(FilenameUtils.getName((String)input))) {
            return false;
        }
        return !ILLEGAL_CHAR_PATTERN.matcher(input).matches();
    }

    @Override
    protected void renderBackground(class_332 guiGraphics, int x, int y, int width, int height, int mouseX, int mouseY, float partialTick) {
        DrawUtil.renderDropShadow(guiGraphics, x, y, width, height, 24);
        super.renderBackground(guiGraphics, x, y, width, height, mouseX, mouseY, partialTick);
    }

    @Override
    protected void renderForeground(class_332 guiGraphics, int x, int y, int width, int height, int mouseX, int mouseY, float partialTick) {
        int spriteX = x + 8;
        int spriteY = this.title.method_46427() + (this.title.method_25364() - this.sprite.height) / 2;
        this.sprite.render(guiGraphics, spriteX, spriteY);
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        boolean keyPressed = super.method_25404(keyCode, scanCode, modifiers);
        if (!keyPressed && this.isOpen() && keyCode == 257 && this.canSave(this.nameEditor.method_1882())) {
            this.saveName();
            return true;
        }
        return keyPressed;
    }

    public boolean method_25400(char codePoint, int modifiers) {
        boolean charTyped = super.method_25400(codePoint, modifiers);
        if (!charTyped && this.isOpen() && !this.nameEditor.method_25370()) {
            this.method_25395(this.nameEditor);
            return this.nameEditor.method_25400(codePoint, modifiers);
        }
        return charTyped;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public class_8016 method_48205(class_8023 event) {
        class_8028 direction;
        if (!this.nameEditor.method_25370() || !(event instanceof class_8023.class_8024)) return super.method_48205(event);
        class_8023.class_8024 class_80242 = (class_8023.class_8024)event;
        try {
            class_8028 class_80282;
            direction = class_80282 = class_80242.comp_1191();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        if (direction.method_48237() != class_8027.field_41822) return super.method_48205(event);
        if (class_437.method_25442()) return class_8016.method_48194(this.nameEditor, (class_4069[])new class_4069[]{this});
        this.nameEditor.method_1884(this.nameEditor.method_1881());
        return class_8016.method_48194(this.nameEditor, (class_4069[])new class_4069[]{this});
    }
}

