/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.gui.components.pack;

import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuItemBuilder;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.Sprite;
import io.github.fishstiz.packed_packs.config.PackOverride;
import io.github.fishstiz.packed_packs.config.Profile;
import io.github.fishstiz.packed_packs.gui.components.SelectionContext;
import io.github.fishstiz.packed_packs.gui.metadata.Toggleable;
import io.github.fishstiz.packed_packs.pack.PackOptionsContext;
import io.github.fishstiz.packed_packs.pack.ProfileScope;
import io.github.fishstiz.packed_packs.transform.interfaces.ConfiguredPack;
import io.github.fishstiz.packed_packs.transform.interfaces.FilePack;
import io.github.fishstiz.packed_packs.util.PackUtil;
import io.github.fishstiz.packed_packs.util.ResourceUtil;
import io.github.fishstiz.packed_packs.util.constants.GuiConstants;
import io.github.fishstiz.packed_packs.util.constants.Theme;
import io.github.fishstiz.packed_packs.util.lang.ObjectsUtil;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_3288;
import net.minecraft.class_332;
import net.minecraft.class_5244;
import net.minecraft.class_7919;
import org.jetbrains.annotations.Nullable;

public record PackListDevMenu(PackOptionsContext options, SelectionContext<class_3288> context, @Nullable Consumer<Event<?>> listener) {
    private static final int DEV_SPRITE_SIZE = 16;
    private static final int DEV_SPRITE_MARGIN_RIGHT = 8;
    private static final Sprite EYE_SLASH_SPRITE = Sprite.of16(ResourceUtil.getIcon("eye_slash"));
    private static final Sprite X_SQUARE = Sprite.of16(ResourceUtil.getIcon("x_square"));
    private static final Sprite ARROW_UP_SPRITE = Sprite.of16(ResourceUtil.getIcon("arrow_up"));
    private static final Sprite ARROW_DOWN_SPRITE = Sprite.of16(ResourceUtil.getIcon("arrow_down"));
    private static final Sprite ARROWS_SPRITE = Sprite.of16(ResourceUtil.getIcon("arrows_vertical"));
    private static final Sprite RADIO_GLOBAL = Sprite.of16(ResourceUtil.getIcon("radio_globe"));
    private static final class_2561 HIDDEN = PackListDevMenu.overrideText("hidden");
    private static final class_2561 REQUIRED = PackListDevMenu.overrideText("required");
    private static final class_2561 FIXED_POSITION = PackListDevMenu.overrideText("fixed");
    private static final class_2561 FIXED_TOP = PackListDevMenu.overrideText("fixed.top");
    private static final class_2561 FIXED_BOTTOM = PackListDevMenu.overrideText("fixed.bottom");
    private static final class_2561 REMOVE_OVERRIDES = PackListDevMenu.overrideText("remove");
    private static final class_7919 REQUIRED_NO_DISABLED_INFO = class_7919.method_47407((class_2561)PackListDevMenu.overrideText("required.no.disabled.info"));

    public PackListDevMenu(PackOptionsContext options, SelectionContext<class_3288> context) {
        this(options, context, null);
    }

    private <T> void notifyListener(T value, List<class_3288> packs, EventFactory<T> eventFactory) {
        if (this.listener != null) {
            this.listener.accept(eventFactory.create(this.pack(), value, packs));
        }
    }

    private static class_2561 overrideText(String keySuffix) {
        return ResourceUtil.getText("profile.override." + keySuffix, new Object[0]);
    }

    private class_3288 pack() {
        return this.context.item();
    }

    private ProfileScope hasOverride(BiPredicate<Profile, class_3288> option) {
        return this.options.hasOverride(this.context.item(), option);
    }

    private List<class_3288> getPackOrSelection() {
        return this.context.getItemOrSelection();
    }

    public void renderDevSprites(class_332 guiGraphics, int top, int left, int width) {
        ProfileScope included;
        ProfileScope hiddenOverride;
        ProfileScope requiredOverride;
        int size = 16;
        int iconX = left + width - size - 8;
        ProfileScope positionOverride = this.hasOverride(Profile::overridesPosition);
        if (positionOverride.exists()) {
            boolean unfixed = !this.options.isFixed(this.pack());
            boolean fixedTop = this.options.getPosition(this.pack()) == class_3288.class_3289.field_14280;
            guiGraphics.method_25294(iconX, top, iconX + size, top + size, PackListDevMenu.getBackgroundColor(positionOverride));
            ObjectsUtil.pick(unfixed, ARROWS_SPRITE, ObjectsUtil.pick(fixedTop, ARROW_UP_SPRITE, ARROW_DOWN_SPRITE)).render(guiGraphics, iconX, top, size, size);
            iconX -= size;
        }
        if ((requiredOverride = this.hasOverride(Profile::overridesRequired)).exists()) {
            boolean required = this.options.isRequired(this.pack());
            guiGraphics.method_25294(iconX, top, iconX + size, top + size, PackListDevMenu.getBackgroundColor(requiredOverride));
            ObjectsUtil.pick(required, GuiConstants.LOCK_SPRITE_SMALL, GuiConstants.UNLOCK_SPRITE_SMALL).render(guiGraphics, iconX, top, size, size);
            iconX -= size;
        }
        if ((hiddenOverride = this.hasOverride(Profile::isHidden)).exists()) {
            guiGraphics.method_25294(iconX, top, iconX + size, top + size, PackListDevMenu.getBackgroundColor(hiddenOverride));
            EYE_SLASH_SPRITE.render(guiGraphics, iconX, top, size, size);
            iconX -= size;
        }
        if ((included = this.hasOverride(Profile::includes)).global() && !((ConfiguredPack)this.pack()).packed_packs$getMetadata().comp_1583().method_14437()) {
            guiGraphics.method_25294(iconX, top, iconX + size, top + size, Theme.RED_700.withAlpha(0.75f));
            X_SQUARE.render(guiGraphics, iconX, top, size, size);
        }
    }

    private void updateHidden(boolean hidden) {
        this.options.getProfile().ifPresent(profile -> {
            List<class_3288> selected = this.getPackOrSelection();
            profile.setHidden(hidden, selected);
            this.notifyListener(hidden, selected, Event.Hide::new);
        });
    }

    private void updateRequired(@Nullable Boolean required) {
        this.options.getProfile().ifPresent(profile -> {
            List<class_3288> selected = this.getPackOrSelection();
            profile.setRequired(required, selected);
            this.notifyListener(required, selected, Event.Require::new);
        });
    }

    private void updatePosition(@Nullable PackOverride.Position position) {
        this.options.getProfile().ifPresent(profile -> {
            List<class_3288> selected = this.getPackOrSelection();
            profile.setPosition(position, selected);
            this.notifyListener(position, selected, Event.Reposition::new);
        });
    }

    private void resetOverrides() {
        this.updateHidden(false);
        this.updateRequired(null);
        this.updatePosition(null);
    }

    private Sprite getIcon(boolean active, BiPredicate<Profile, class_3288> defaultOption) {
        return this.hasOverride(defaultOption) == ProfileScope.GLOBAL ? RADIO_GLOBAL : Toggleable.getDefaultIcon(active);
    }

    private boolean canDisableRequired() {
        return this.options.isDefaultProfile() && !PackUtil.isEssential(this.pack());
    }

    public void onBuildHeader(ContextMenuItemBuilder builder) {
        Profile profile = this.options.getProfile().orElse(null);
        if (profile == null) {
            return;
        }
        builder.add(GuiConstants.devItem(HIDDEN).icon(() -> this.getIcon(profile.isHidden(this.pack()), Profile::isHidden)).activeWhen(() -> this.hasOverride(Profile::isHidden) != ProfileScope.GLOBAL).action(() -> this.updateHidden(!profile.isHidden(this.pack()))).closeOnInteract(false).build());
        builder.add(GuiConstants.devItem(REQUIRED).icon(() -> this.options.isLocked() ? GuiConstants.LOCK_SPRITE_SMALL : this.getIcon(profile.overridesRequired(this.pack()), Profile::overridesRequired)).activeWhen(() -> !this.options.isLocked() && this.hasOverride(Profile::overridesRequired) != ProfileScope.GLOBAL && !((FilePack)this.pack()).packed_packs$nestedPack()).closeOnInteract(false).addChild(GuiConstants.devItem(class_5244.field_24333).icon(() -> Toggleable.getDefaultIcon(!profile.overridesRequired(this.pack()))).action(() -> this.updateRequired(null)).closeOnInteract(false).build()).addChild(GuiConstants.devItem(class_5244.field_24337).icon(() -> Toggleable.getDefaultIcon(profile.overridesRequired(this.pack()) && !profile.isRequired(this.pack()))).activeWhen(this::canDisableRequired).tooltip(() -> !this.canDisableRequired() && !PackUtil.isEssential(this.pack()) ? REQUIRED_NO_DISABLED_INFO : null).action(() -> this.updateRequired(false)).closeOnInteract(false).build()).addChild(GuiConstants.devItem(class_5244.field_24336).icon(() -> Toggleable.getDefaultIcon(profile.isRequired(this.pack()))).action(() -> this.updateRequired(true)).closeOnInteract(false).build()).build());
        builder.add(GuiConstants.devItem(FIXED_POSITION).icon(() -> this.getIcon(profile.overridesPosition(this.pack()), Profile::overridesPosition)).activeWhen(() -> this.hasOverride(Profile::overridesPosition) != ProfileScope.GLOBAL).closeOnInteract(false).addChild(GuiConstants.devItem(class_5244.field_24333).icon(() -> Toggleable.getDefaultIcon(!profile.overridesPosition(this.pack()))).action(() -> this.updatePosition(null)).closeOnInteract(false).build()).addChild(GuiConstants.devItem(class_5244.field_24337).icon(() -> Toggleable.getDefaultIcon(profile.overridesPosition(this.pack()) && !profile.isFixed(this.pack()))).action(() -> this.updatePosition(PackOverride.Position.UNFIXED)).closeOnInteract(false).build()).addChild(GuiConstants.devItem(FIXED_TOP).icon(() -> Toggleable.getDefaultIcon(profile.getPositionOverride(this.pack()) == PackOverride.Position.TOP)).action(() -> this.updatePosition(PackOverride.Position.TOP)).closeOnInteract(false).build()).addChild(GuiConstants.devItem(FIXED_BOTTOM).icon(() -> Toggleable.getDefaultIcon(profile.getPositionOverride(this.pack()) == PackOverride.Position.BOTTOM)).action(() -> this.updatePosition(PackOverride.Position.BOTTOM)).closeOnInteract(false).build()).build());
        builder.add(GuiConstants.devItem(REMOVE_OVERRIDES).action(this::resetOverrides).build()).separator();
    }

    private static int getBackgroundColor(ProfileScope overrideScope) {
        return switch (overrideScope) {
            default -> throw new MatchException(null, null);
            case ProfileScope.NONE -> Theme.WHITE.withAlpha(0.0f);
            case ProfileScope.LOCAL -> Theme.BLACK.withAlpha(0.75f);
            case ProfileScope.GLOBAL -> Theme.BLUE_500.withAlpha(0.75f);
            case ProfileScope.COMPOSITE -> Theme.PURPLE_500.withAlpha(0.75f);
        };
    }

    @FunctionalInterface
    private static interface EventFactory<T> {
        public Event<T> create(class_3288 var1, T var2, List<class_3288> var3);
    }

    public static sealed interface Event<T> {
        public class_3288 trigger();

        public List<class_3288> packs();

        public T value();

        public static final class Reposition
        extends Record
        implements Event<PackOverride.Position> {
            private final class_3288 trigger;
            @Nullable
            private final PackOverride.Position value;
            private final List<class_3288> packs;

            public Reposition(class_3288 trigger, @Nullable PackOverride.Position value, List<class_3288> packs) {
                this.trigger = trigger;
                this.value = value;
                this.packs = packs;
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{Reposition.class, "trigger;value;packs", "trigger", "value", "packs"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Reposition.class, "trigger;value;packs", "trigger", "value", "packs"}, this);
            }

            @Override
            public final boolean equals(Object o) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Reposition.class, "trigger;value;packs", "trigger", "value", "packs"}, this, o);
            }

            @Override
            public class_3288 trigger() {
                return this.trigger;
            }

            @Override
            @Nullable
            public PackOverride.Position value() {
                return this.value;
            }

            @Override
            public List<class_3288> packs() {
                return this.packs;
            }
        }

        public static final class Require
        extends Record
        implements Event<Boolean> {
            private final class_3288 trigger;
            @Nullable
            private final Boolean value;
            private final List<class_3288> packs;

            public Require(class_3288 trigger, @Nullable Boolean value, List<class_3288> packs) {
                this.trigger = trigger;
                this.value = value;
                this.packs = packs;
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{Require.class, "trigger;value;packs", "trigger", "value", "packs"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Require.class, "trigger;value;packs", "trigger", "value", "packs"}, this);
            }

            @Override
            public final boolean equals(Object o) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Require.class, "trigger;value;packs", "trigger", "value", "packs"}, this, o);
            }

            @Override
            public class_3288 trigger() {
                return this.trigger;
            }

            @Override
            @Nullable
            public Boolean value() {
                return this.value;
            }

            @Override
            public List<class_3288> packs() {
                return this.packs;
            }
        }

        public static final class Hide
        extends Record
        implements Event<Boolean> {
            private final class_3288 trigger;
            private final Boolean value;
            private final List<class_3288> packs;

            public Hide(class_3288 trigger, Boolean value, List<class_3288> packs) {
                this.trigger = trigger;
                this.value = value;
                this.packs = packs;
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{Hide.class, "trigger;value;packs", "trigger", "value", "packs"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Hide.class, "trigger;value;packs", "trigger", "value", "packs"}, this);
            }

            @Override
            public final boolean equals(Object o) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Hide.class, "trigger;value;packs", "trigger", "value", "packs"}, this, o);
            }

            @Override
            public class_3288 trigger() {
                return this.trigger;
            }

            @Override
            public Boolean value() {
                return this.value;
            }

            @Override
            public List<class_3288> packs() {
                return this.packs;
            }
        }
    }
}

