/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.pack;

import io.github.fishstiz.packed_packs.config.Config;
import io.github.fishstiz.packed_packs.config.PackOptions;
import io.github.fishstiz.packed_packs.config.Profile;
import io.github.fishstiz.packed_packs.pack.PackOptionsResolver;
import io.github.fishstiz.packed_packs.pack.ProfileScope;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import net.minecraft.class_3288;
import net.minecraft.class_9225;
import org.jetbrains.annotations.Nullable;

public class PackOptionsContext
implements PackOptions {
    private final PackOptionsResolver resolver;

    public PackOptionsContext(PackOptionsResolver resolver) {
        this.resolver = resolver;
    }

    public PackOptionsContext(Supplier<@Nullable Profile> profileSupplier, Config.Packs config) {
        this(new PackOptionsResolver(profileSupplier, config));
    }

    @Override
    public boolean isHidden(class_3288 pack) {
        return this.resolver.isHidden(pack);
    }

    @Override
    public boolean isRequired(class_3288 pack) {
        return this.resolver.isRequiredOrDefault(pack);
    }

    @Override
    public boolean isFixed(class_3288 pack) {
        return this.resolver.isFixedOrDefault(pack);
    }

    @Override
    public class_3288.class_3289 getPosition(class_3288 pack) {
        return this.resolver.getPositionOrDefault(pack);
    }

    @Override
    public class_9225 getSelectionConfig(class_3288 pack) {
        return this.resolver.getSelectionConfigOrDefault(pack);
    }

    public Optional<Profile> getProfile() {
        return Optional.ofNullable(this.resolver.profileSupplier().get());
    }

    public Optional<Profile> getDefaultProfile() {
        return Optional.ofNullable(this.resolver.config().getDefaultProfile());
    }

    public void validate(class_3288 pack) {
        Profile profile = this.resolver.profileSupplier().get();
        if (profile == null) {
            return;
        }
        Profile defaultProfile = this.resolver.config().getDefaultProfile();
        if (!(defaultProfile != null && defaultProfile.overridesRequired(pack) || !profile.overridesRequired(pack) || profile.isRequired(pack))) {
            profile.setRequired(null, pack);
        }
    }

    public boolean isLocked() {
        Profile profile = this.resolver.profileSupplier().get();
        return profile != null && profile.isLocked();
    }

    public boolean isDefaultProfile() {
        Profile profile = this.resolver.profileSupplier().get();
        return profile != null && profile == this.resolver.config().getDefaultProfile();
    }

    public Config.Packs getConfig() {
        return this.resolver.config();
    }

    public boolean hasOverride(class_3288 pack) {
        Profile defaultProfile = this.resolver.config().getDefaultProfile();
        Profile profile = this.resolver.profileSupplier().get();
        return defaultProfile != null && defaultProfile.hasOverride(pack) || profile != null && profile.hasOverride(pack);
    }

    public ProfileScope hasOverride(class_3288 pack, BiPredicate<Profile, class_3288> option) {
        Profile defaultProfile = this.resolver.config().getDefaultProfile();
        Profile profile = this.resolver.profileSupplier().get();
        ProfileScope scope = ProfileScope.NONE;
        if (defaultProfile != null && option.test(defaultProfile, pack)) {
            scope = ProfileScope.GLOBAL;
        }
        if (profile != null && option.test(profile, pack)) {
            scope = !scope.exists() ? ProfileScope.LOCAL : ProfileScope.COMPOSITE;
        }
        return scope;
    }
}

