/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.pack.folder;

import io.github.fishstiz.packed_packs.config.ConfigLoader;
import io.github.fishstiz.packed_packs.config.Folder;
import io.github.fishstiz.packed_packs.pack.folder.FolderResourcesSupplier;
import io.github.fishstiz.packed_packs.transform.interfaces.FilePack;
import io.github.fishstiz.packed_packs.util.PackUtil;
import io.github.fishstiz.packed_packs.util.ResourceUtil;
import io.github.fishstiz.packed_packs.util.lang.ObjectsUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_3262;
import net.minecraft.class_3281;
import net.minecraft.class_3288;
import net.minecraft.class_7367;
import net.minecraft.class_7699;
import net.minecraft.class_9224;
import net.minecraft.class_9225;
import org.jetbrains.annotations.Nullable;

public class FolderPack
extends class_3288
implements FilePack {
    public static final class_2561 FOLDER_OPEN_TEXT = ResourceUtil.getText("folder.open", new Object[0]);
    public static final class_2561 FOLDER_DESCRIPTION = ResourceUtil.getText("folder", new Object[0]);
    public static final class_9225 FOLDER_SELECTION_CONFIG = new class_9225(false, class_3288.class_3289.field_14280, false);
    public static final class_3288.class_7679 FOLDER_METADATA = new class_3288.class_7679(FOLDER_DESCRIPTION, class_3281.field_14224, class_7699.method_45397(), Collections.emptyList());
    private final Function<String, List<class_3288>> nestedPacksProvider;
    private final Path path;

    public FolderPack(String id, String name, Function<String, List<class_3288>> nestedPacksProvider, Path path) {
        super(new class_9224(id, (class_2561)class_2561.method_43470((String)name), PackUtil.PACK_SOURCE, Optional.empty()), (class_3288.class_7680)new FolderResourcesSupplier(path), FOLDER_METADATA, FOLDER_SELECTION_CONFIG);
        this.nestedPacksProvider = nestedPacksProvider;
        this.path = path;
    }

    public List<class_3288> flatten() {
        ObjectArrayList result = new ObjectArrayList();
        result.add(this);
        result.addAll(ObjectsUtil.getOrDefault(this.nestedPacksProvider.apply(this.method_14463()), Collections.emptyList()));
        return result;
    }

    public CompletableFuture<Folder> loadConfig() {
        return CompletableFuture.supplyAsync(() -> {
            try (class_3262 resources = this.method_14458();){
                Folder folder;
                block16: {
                    class_7367 configIoSupplier = resources.method_14410(new String[]{"packed_packs.folderpack.json"});
                    if (configIoSupplier == null) {
                        throw new IOException();
                    }
                    InputStream inputStream = (InputStream)configIoSupplier.get();
                    try {
                        folder = ConfigLoader.load(inputStream, Folder.class);
                        if (inputStream == null) break block16;
                    }
                    catch (Throwable throwable) {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    inputStream.close();
                }
                return folder;
            }
            catch (NoSuchFileException e) {
                return ObjectsUtil.peek(new Folder(), this::saveConfig);
            }
            catch (IOException e) {
                return new Folder();
            }
        }, (Executor)class_156.method_18349());
    }

    public void saveConfig(Folder folder) {
        if (folder != null) {
            folder.save(this.path.resolve("packed_packs.folderpack.json"));
        }
    }

    @Override
    @Nullable
    public Path packed_packs$getPath() {
        return this.path;
    }
}

