package io.github.fishstiz.fidgetz.gui.components.contextmenu;

import io.github.fishstiz.fidgetz.gui.renderables.RenderableRect;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.Sprite;
import io.github.fishstiz.fidgetz.util.ARGBColor;
import org.jetbrains.annotations.Nullable;

import java.util.Collections;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_5244;
import net.minecraft.class_7919;

public interface MenuItem {
    MenuItem SEPARATOR = builder(class_5244.field_39003)
            .closeOnInteract(false)
            .autoSeparate(false)
            .build();

    class_2561 text();

    Runnable action();

    default @Nullable RenderableRect background() {
        return null;
    }

    default @Nullable Sprite icon() {
        return null;
    }

    default @Nullable class_7919 tooltip() {
        return null;
    }

    default boolean shouldAutoSeparate() {
        return true;
    }

    default boolean shouldCloseOnInteract() {
        return true;
    }

    default boolean active() {
        return true;
    }

    default int textColor() {
        return this.active() ? ARGBColor.WHITE : ContextMenu.DEFAULT_TEXT_INACTIVE_COLOR;
    }

    default List<? extends MenuItem> children() {
        return Collections.emptyList();
    }

    default boolean parent() {
        return !this.children().isEmpty();
    }

    static MenuItemBuilder builder(class_2561 text) {
        return new MenuItemBuilder(text);
    }
}
