package io.github.fishstiz.packed_packs.util;

import static net.minecraft.class_3675.*;

import net.minecraft.class_1041;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_156;
import net.minecraft.class_310;
import net.minecraft.class_3675;

public class InputUtil {
    public static final String DEV_MODE_SHORTCUT = "CTRL + SHIFT + I";
    public static final class_1041 WINDOW = class_310.method_1551().method_22683();
    public static final long DOUBLE_CLICK_THRESHOLD_MS = 250;
    public static final int MOUSE_BUTTON_BACK = 3;
    public static final int MOUSE_BUTTON_FORWARD = 4;

    private InputUtil() {
    }

    public static boolean isLeftClick(class_11909 mouseEvent) {
        return mouseEvent.method_74245() == field_32000;
    }

    public static boolean isRightClick(class_11909 mouseEvent) {
        return mouseEvent.method_74245() == field_32002;
    }

    public static boolean isClickBack(class_11909 mouseEvent) {
        return mouseEvent.method_74245() == MOUSE_BUTTON_BACK;
    }

    public static boolean isClickForward(class_11909 mouseEvent) {
        return mouseEvent.method_74245() == MOUSE_BUTTON_FORWARD;
    }

    public static boolean isUndo(class_11908 keyEvent) {
        return keyEvent.comp_4795() == field_31915 && keyEvent.method_74240() && keyEvent.comp_4797() == field_32003;
    }

    public static boolean isRedo(class_11908 keyEvent) {
        if (keyEvent.comp_4795() == field_31915) {
            return keyEvent.method_74240() && keyEvent.method_74239() && keyEvent.comp_4797() == field_32003 + field_62548;
        } else if (keyEvent.comp_4795() == field_31914) {
            return keyEvent.method_74240() && keyEvent.comp_4797() == field_32003;
        }

        return false;
    }

    public static boolean isTransfer(class_11908 keyEvent) {
        return noModifiers(keyEvent.comp_4797()) && (keyEvent.comp_4795() == field_31947 || keyEvent.comp_4795() == field_31957);
    }

    public static boolean isMoveDown(class_11908 keyEvent) {
        return keyEvent.comp_4795() == field_31982 && moveModifiers(keyEvent.comp_4797());
    }

    public static boolean isMoveUp(class_11908 keyEvent) {
        return keyEvent.comp_4795() == field_31932 && moveModifiers(keyEvent.comp_4797());
    }

    public static boolean isExpandFolder(class_11908 keyEvent) {
        return noModifiers(keyEvent.comp_4797()) && keyEvent.comp_4795() == field_31957;
    }

    public static boolean isDelete(class_11908 keyEvent) {
        return noModifiers(keyEvent.comp_4797()) && keyEvent.comp_4795() == field_31987;
    }

    public static boolean isRename(class_11908 keyEvent) {
        return (noModifiers(keyEvent.comp_4797()) && keyEvent.comp_4795() == field_31917) ||
               (keyEvent.comp_4797() == field_32003 && keyEvent.comp_4795() == field_31907);
    }

    public static boolean isRefresh(class_11908 keyEvent) {
        return noModifiers(keyEvent.comp_4797()) && keyEvent.comp_4795() == field_31920;
    }

    public static boolean isOpenFile(class_11908 keyEvent) {
        return keyEvent.comp_4797() == field_32003 && keyEvent.comp_4795() == field_31957;
    }

    public static boolean isOpenFolder(class_11908 keyEvent) {
        return keyEvent.comp_4797() == field_62549 + field_62548 && keyEvent.comp_4795() == field_31907;
    }

    public static boolean isDeveloperMode(class_11908 keyEvent) {
        return keyEvent.comp_4797() == field_32003 + field_62548 && keyEvent.comp_4795() == field_32023;
    }

    public static boolean noModifiers(int modifiers) {
        return modifiers == 0;
    }

    public static boolean moveModifiers(int modifiers) {
        return modifiers == field_32003 || modifiers == field_62549;
    }

    public static boolean isRangeModifierActive() {
        return hasShiftDown();
    }

    public static boolean isSelectModifierActive() {
        return hasControlDown();
    }

    public static boolean hasControlDown() {
        return class_156.method_668() == class_156.class_158.field_1137
                ? class_3675.method_15987(WINDOW, field_31952) || class_3675.method_15987(WINDOW, field_31956)
                : class_3675.method_15987(WINDOW, field_31950) || class_3675.method_15987(WINDOW, field_31954);
    }

    public static boolean hasShiftDown() {
        return class_3675.method_15987(WINDOW, field_31951) || class_3675.method_15987(WINDOW, field_31955);
    }

    public static boolean hasAltDown() {
        return class_3675.method_15987(WINDOW, field_31949) || class_3675.method_15987(WINDOW, field_31953);
    }
}
