package io.github.fishstiz.fidgetz.gui.layouts;

import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import net.minecraft.class_339;
import net.minecraft.class_7847;
import net.minecraft.class_8021;
import net.minecraft.class_8133;
import net.minecraft.class_8667;

public class FlexLayout implements class_8133 {
    private final List<Child<? extends class_8021>> children = new ArrayList<>();
    private final class_8667 wrappedLayout;
    private final class_8667.class_8668 orientation;
    private final @Nullable IntSupplier maxSize;
    private int maxWidth;
    private int maxHeight;
    private int spacing;

    protected FlexLayout(class_8667.class_8668 orientation, IntSupplier maxSize, int maxWidth, int maxHeight, int spacing) {
        this.wrappedLayout = new class_8667(0, 0, orientation).method_52735(spacing);
        this.orientation = orientation;
        this.maxSize = maxSize;
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        this.spacing = spacing;
    }

    public <T extends class_8021> T addChild(T child, class_7847 layoutSettings) {
        this.children.add(new Child<>(child, layoutSettings));
        return this.wrappedLayout.method_52737(child, layoutSettings);
    }

    public <T extends class_8021> T addChild(T child) {
        return this.addChild(child, this.wrappedLayout.method_52739());
    }

    public <T extends class_339> T addFlexChild(T child, boolean crossAxis, class_7847 layoutSettings) {
        this.children.add(new FlexWidget(child, crossAxis, layoutSettings));
        return this.wrappedLayout.method_52737(child, layoutSettings);
    }

    public <T extends class_339> T addFlexChild(T child, boolean crossAxis) {
        return this.addFlexChild(child, crossAxis, this.wrappedLayout.method_52739());
    }

    public <T extends class_339> T addFlexChild(T child) {
        return this.addFlexChild(child, false, this.wrappedLayout.method_52739());
    }

    public <T extends FlexLayout> T addFlexChild(T child, boolean crossAxis, class_7847 layoutSettings) {
        this.children.add(new NestedFlexLayout(child, crossAxis, layoutSettings));
        return this.wrappedLayout.method_52737(child, layoutSettings);
    }

    public <T extends FlexLayout> T addFlexChild(T child, boolean crossAxis) {
        return this.addFlexChild(child, crossAxis, this.wrappedLayout.method_52739());
    }

    public <T extends FlexLayout> T addFlexChild(T child) {
        return this.addFlexChild(child, false, this.wrappedLayout.method_52739());
    }

    private int getCurrentMax() {
        return this.orientation == class_8667.class_8668.field_45403 ? this.maxWidth : this.maxHeight;
    }

    private int getFlexDistribution() {
        int padding = 0;
        int totalSize = 0;
        int flexCount = 0;

        for (int i = 0; i < this.children.size(); i++) {
            Child<?> child = this.children.get(i);

            if (child instanceof FlexChild<?>) {
                flexCount++;
            } else {
                totalSize += child.getAxisSize(this.orientation);
            }

            if (i < this.children.size() - 1) {
                totalSize += spacing;
            }

            var layoutSettings = child.layoutSettings.method_46480();
            padding += this.orientation == class_8667.class_8668.field_45403
                    ? layoutSettings.field_40778 + layoutSettings.field_40779
                    : layoutSettings.field_40779 + layoutSettings.field_40781;
        }

        int max = this.maxSize != null ? this.maxSize.getAsInt() : this.getCurrentMax();
        return flexCount > 0 ? (max - padding - totalSize) / flexCount : 0;
    }

    @Override
    public void method_48222() {
        int distribution = this.getFlexDistribution();

        for (Child<?> child : this.children) {
            if (child instanceof FlexChild<?> flexChild) {
                flexChild.setAxisSizes(this.orientation, distribution, this.maxWidth, this.maxHeight);
            }
        }

        this.wrappedLayout.method_48222();
    }

    @Override
    public void method_48227(Consumer<class_8021> visitor) {
        this.wrappedLayout.method_48227(visitor);
    }

    @Override
    public void method_46421(int x) {
        this.wrappedLayout.method_46421(x);
    }

    @Override
    public void method_46419(int y) {
        this.wrappedLayout.method_46419(y);
    }

    @Override
    public int method_46426() {
        return this.wrappedLayout.method_46426();
    }

    @Override
    public int method_46427() {
        return this.wrappedLayout.method_46427();
    }

    @Override
    public int method_25368() {
        return this.wrappedLayout.method_25368();
    }

    @Override
    public int method_25364() {
        return this.wrappedLayout.method_25364();
    }

    public FlexLayout spacing(int spacing) {
        this.wrappedLayout.method_52735(spacing);
        this.spacing = spacing;
        return this;
    }

    public FlexLayout copyLayout() {
        return new FlexLayout(this.orientation, this.maxSize, this.maxWidth, this.maxHeight, this.spacing);
    }

    public static FlexLayout horizontal(IntSupplier maxWidth) {
        return new FlexLayout(class_8667.class_8668.field_45403, maxWidth, maxWidth.getAsInt(), 0, 0);
    }

    public static FlexLayout horizontal() {
        return new FlexLayout(class_8667.class_8668.field_45403, null, 0, 0, 0);
    }

    public static FlexLayout vertical(IntSupplier maxHeight) {
        return new FlexLayout(class_8667.class_8668.field_45404, maxHeight, 0, maxHeight.getAsInt(), 0);
    }

    public static FlexLayout vertical() {
        return new FlexLayout(class_8667.class_8668.field_45404, null, 0, 0, 0);
    }

    private static class Child<T extends class_8021> {
        protected final T element;
        protected final class_7847 layoutSettings;

        protected Child(T element, class_7847 layoutSettings) {
            this.element = element;
            this.layoutSettings = layoutSettings;
        }

        protected int getAxisSize(class_8667.class_8668 orientation) {
            return orientation == class_8667.class_8668.field_45403 ? this.getWidth() : this.getHeight();
        }

        protected int getWidth() {
            return this.element.method_25368();
        }

        protected int getHeight() {
            return this.element.method_25364();
        }
    }

    private abstract static class FlexChild<T extends class_8021> extends Child<T> {
        protected final boolean crossAxis;

        protected FlexChild(T element, boolean crossAxis, class_7847 layoutSettings) {
            super(element, layoutSettings);

            this.crossAxis = crossAxis;
        }

        protected abstract void setWidth(int width);

        protected abstract void setHeight(int height);

        protected void setAxisSizes(class_8667.class_8668 orientation, int size, int maxWidth, int maxHeight) {
            if (orientation == class_8667.class_8668.field_45403) {
                this.setWidth(size);
                if (this.crossAxis && maxHeight > 0) {
                    this.setHeight(maxHeight);
                }
            } else {
                this.setHeight(size);
                if (this.crossAxis && maxWidth > 0) {
                    this.setWidth(maxWidth);
                }
            }
        }
    }

    private static class FlexWidget extends FlexChild<class_339> {
        private FlexWidget(class_339 element, boolean crossAxis, class_7847 layoutSettings) {
            super(element, crossAxis, layoutSettings);
        }

        @Override
        protected void setWidth(int width) {
            this.element.method_25358(width);
        }

        @Override
        protected void setHeight(int height) {
            this.element.method_53533(height);
        }
    }

    private static class NestedFlexLayout extends FlexChild<FlexLayout> {
        protected NestedFlexLayout(FlexLayout element, boolean crossAxis, class_7847 layoutSettings) {
            super(element, crossAxis, layoutSettings);
        }

        @Override
        protected int getWidth() {
            return this.element.maxWidth;
        }

        @Override
        protected int getHeight() {
            return this.element.maxHeight;
        }

        @Override
        protected void setWidth(int width) {
            this.element.maxWidth = width;
        }

        @Override
        protected void setHeight(int height) {
            this.element.maxHeight = height;
        }
    }
}
