package io.github.fishstiz.packed_packs.compat.respackopts;

import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuItemBuilder;
import io.github.fishstiz.packed_packs.compat.Mod;
import io.github.fishstiz.packed_packs.compat.ModContext;
import io.github.fishstiz.packed_packs.compat.ModExtensionInternal;
import io.github.fishstiz.packed_packs.config.Config;
import io.github.fishstiz.packed_packs.config.ModPreferences;
import io.github.fishstiz.packed_packs.gui.components.ToggleableHelper;
import io.github.fishstiz.packed_packs.gui.components.pack.PackList;
import org.jspecify.annotations.Nullable;

import java.nio.file.Path;
import net.minecraft.class_2960;
import net.minecraft.class_3264;

public class RespackoptsModExtension implements ModExtensionInternal {
    @Override
    public ModContext mod() {
        return Mod.RESPACKOPTS;
    }

    @Override
    public @Nullable class_2960[] loadAfter() {
        return new class_2960[]{Mod.ETF.getInternalId()};
    }

    @Override
    public void onCreateEntry(class_3264 type, PackList.Entry entry) {
        if (type != class_3264.field_14188) return;

        this.mod().wrapError(entry, e -> {
            if (Config.get().isDevMode() || ModPreferences.RESPACKOPTS_BUTTON.isEnabled()) {
                RespackoptsWidget widget = RespackoptsWidget.create(e, e.pack());
                if (widget != null) e.addTopRenderableOnly(e.prependWidget(widget));
            }
        });
    }

    @Override
    public void onCreatePreferencesMenu(class_3264 type, ContextMenuItemBuilder builder) {
        if (type != class_3264.field_14188) return;

        this.mod().wrapError(builder, b -> b.add(ToggleableHelper.fromPref(ModPreferences.RESPACKOPTS_BUTTON.get())));
    }

    @Override
    public boolean forceCommitOnClose(class_3264 type) {
        return type == class_3264.field_14188 && this.mod().wrapError(RespackoptsUtil::isForceReload, false);
    }

    @Override
    public boolean shouldIgnoreChange(class_3264 type, Path path) {
        return this.mod().wrapError(RespackoptsUtil::isRespackOptsFile, false, path);
    }
}