package io.github.fishstiz.packed_packs.compat.vtdownloader;

import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuItemBuilder;
import io.github.fishstiz.fidgetz.gui.layouts.FlexLayout;
import io.github.fishstiz.packed_packs.compat.FabricMod;
import io.github.fishstiz.packed_packs.compat.Mod;
import io.github.fishstiz.packed_packs.compat.ModContext;
import io.github.fishstiz.packed_packs.compat.ModExtensionInternal;
import io.github.fishstiz.packed_packs.config.Config;
import io.github.fishstiz.packed_packs.config.FabricPreferences;
import io.github.fishstiz.packed_packs.gui.components.pack.PackList;
import io.github.fishstiz.packed_packs.gui.components.ToggleableHelper;
import io.github.fishstiz.packed_packs.gui.screens.PackedPacksScreen;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_5375;
import org.jspecify.annotations.Nullable;

public class VTDModExtension implements ModExtensionInternal {
    @Override
    public ModContext mod() {
        return FabricMod.VTD;
    }

    @Override
    public @Nullable class_2960[] loadAfter() {
        return new class_2960[]{Mod.RESPACKOPTS.getInternalId(), Mod.ETF.getInternalId()};
    }

    @Override
    public void onCreateHeader(class_3264 type, FlexLayout header, PackedPacksScreen screen, class_5375 original) {
        if (type != class_3264.field_14188) return;

        this.mod().wrapError(header, screen, (layout, prev) -> {
            if (Config.get().isDevMode() || FabricPreferences.VTD_BUTTON.isEnabled()) {
                layout.addChild(VTDButtonFactory.create(prev));
            }
        });
    }

    @Override
    public void onCreateEntry(class_3264 type, PackList.Entry entry) {
        if (type != class_3264.field_14188) return;

        this.mod().wrapError(entry, e -> {
            if (Config.get().isDevMode() || FabricPreferences.VTD_EDIT_BUTTON.isEnabled()) {
                VTDEditButtonWidget widget = VTDEditButtonWidget.create(class_310.method_1551().field_1755, e);
                if (widget != null) e.addTopRenderableOnly(e.prependWidget(widget));
            }
        });
    }

    @Override
    public void onCreatePreferencesMenu(class_3264 type, ContextMenuItemBuilder builder) {
        if (type != class_3264.field_14188) return;

        this.mod().wrapError(builder, b -> {
            b.add(ToggleableHelper.fromPref(FabricPreferences.VTD_BUTTON.get()));
            b.add(ToggleableHelper.fromPref(FabricPreferences.VTD_EDIT_BUTTON.get()));
        });
    }
}
