package io.github.fishstiz.packed_packs.gui.components.events;

import io.github.fishstiz.packed_packs.gui.components.pack.PackList;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

import java.util.List;
import java.util.Objects;
import net.minecraft.class_3288;

public record RequestTransferEvent(
        PackList target,
        @Nullable class_3288 trigger,
        List<class_3288> payload
) implements PackListEvent {
    public RequestTransferEvent {
        payload = List.copyOf(payload);
    }

    public RequestTransferEvent(PackList target, @NonNull class_3288 trigger) {
        this(target, Objects.requireNonNull(trigger), List.of(trigger));
    }

    @Override
    public boolean pushToHistory() {
        return true;
    }
}