package io.github.fishstiz.packed_packs.gui.components.pack;

import io.github.fishstiz.packed_packs.gui.components.SelectionContext;
import io.github.fishstiz.packed_packs.gui.components.events.*;
import io.github.fishstiz.packed_packs.pack.PackAssetManager;
import io.github.fishstiz.packed_packs.pack.PackFileOperations;
import io.github.fishstiz.packed_packs.pack.PackOptionsContext;
import net.minecraft.class_3288;
import net.minecraft.class_332;
import org.jspecify.annotations.NonNull;

public class FolderPackList extends CurrentPackList {
    public FolderPackList(PackOptionsContext options, PackAssetManager assets, PackFileOperations fileOps, PackListEventListener listener) {
        super(options, assets, fileOps, listener);
    }

    @Override
    protected @NonNull io.github.fishstiz.packed_packs.gui.components.pack.CurrentPackList.Entry createEntry(SelectionContext<class_3288> context, int index) {
        return new SubPackEntry(context, index);
    }

    @Override
    public boolean isTransferable(class_3288 pack) {
        return false;
    }

    @Override
    public boolean canInteract(PackList source) {
        return source == this;
    }

    @Override
    public boolean canDrop(DragEvent dragEvent, double mouseX, double mouseY) {
        return this.canInteract(dragEvent.target()) && super.canDrop(dragEvent, mouseX, mouseY);
    }

    @Override
    public void renderDroppableZone(class_332 guiGraphics, DragEvent dragEvent, int mouseX, int mouseY, float partialTick) {
        if (dragEvent.target() == this) {
            super.renderDroppableZone(guiGraphics, dragEvent, mouseX, mouseY, partialTick);
        }
    }

    protected class SubPackEntry extends io.github.fishstiz.packed_packs.gui.components.pack.CurrentPackList.Entry {
        protected SubPackEntry(SelectionContext<class_3288> context, int index) {
            super(context, index);
        }

        @Override
        public boolean isTransferable() {
            return false;
        }
    }
}
