package io.github.fishstiz.packed_packs.gui.components.pack;

import io.github.fishstiz.fidgetz.gui.components.CyclicButton;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.ButtonSprites;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.Sprite;
import io.github.fishstiz.fidgetz.gui.shapes.Size;
import io.github.fishstiz.packed_packs.util.ResourceUtil;
import io.github.fishstiz.packed_packs.pack.folder.FolderPack;
import io.github.fishstiz.packed_packs.util.PackUtil;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

import java.util.Comparator;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_2561;
import net.minecraft.class_3288;
import net.minecraft.class_7919;

public record Query(
        boolean hideIncompatible,
        SortOption sort,
        String search,
        String unmodifiedSearch
) implements Predicate<class_3288>, Comparator<class_3288> {
    public Query {
        search = search != null ? search.toLowerCase(Locale.ROOT) : null;
    }

    public Query(Query query) {
        this(query.hideIncompatible, query.sort, query.search, query.unmodifiedSearch);
    }

    Query() {
        this(false, null, null, null);
    }

    public Query withHideIncompatible(boolean hideIncompatible) {
        if (this.hideIncompatible == hideIncompatible) return this;
        return new Query(hideIncompatible, this.sort, this.search, this.unmodifiedSearch);
    }

    public Query withSort(SortOption sort) {
        if (Objects.equals(this.sort, sort)) return this;
        return new Query(this.hideIncompatible, sort, this.search, this.unmodifiedSearch);
    }

    public Query withSearch(String search) {
        String searchLower = search != null ? search.toLowerCase(Locale.ROOT) : null;
        if (Objects.equals(this.search, searchLower)) return this;
        return new Query(this.hideIncompatible, this.sort, searchLower, search);
    }

    @Override
    public boolean test(class_3288 pack) {
        if (pack == null) {
            return false;
        }
        if (this.hideIncompatible && !pack.method_14460().method_14437()) {
            return false;
        }
        if (this.search != null && !normalizeTitle(pack.method_14457().getString()).toLowerCase(Locale.ROOT).contains(this.search)) {
            return false;
        }
        return true;
    }

    @Override
    public int compare(class_3288 first, class_3288 second) {
        return this.sort != null ? this.sort.comparator.compare(first, second) : 0;
    }

    boolean hasQuery() {
        return this.hideIncompatible || (this.search != null && !this.search.isEmpty()) || this.sort != null;
    }

    public enum SortOption implements CyclicButton.SpriteOption {
        VANILLA("sort.vanilla", "sort_vanilla", (first, second) -> {
            boolean builtInFirst = PackUtil.isBuiltIn(first);
            boolean builtInSecond = PackUtil.isBuiltIn(second);
            if (builtInFirst != builtInSecond) return builtInFirst ? 1 : -1;

            boolean featureFirst = PackUtil.isFeature(first);
            boolean featureSecond = PackUtil.isFeature(second);
            if (featureFirst != featureSecond) return featureFirst ? 1 : -1;

            return first.method_14457().getString().compareTo(second.method_14457().getString());
        }),
        A_Z("sort.a_z", "sort_a_z", Comparator.comparing(
                pack -> normalizeTitle(pack.method_14457().getString()),
                String.CASE_INSENSITIVE_ORDER
        )),
        Z_A("sort.z_a", "sort_z_a", A_Z.comparator.reversed()),
        RECENT("sort.recent", "sort_recent", Comparator.comparingLong(PackUtil::getLastUpdatedEpochMs).reversed()),
        OLDEST("sort.oldest", "sort_oldest", RECENT.comparator.reversed());

        private final class_2561 component;
        private final class_7919 tooltip;
        private final ButtonSprites sprites;
        private final Comparator<class_3288> comparator;

        SortOption(String key, String icon, Comparator<class_3288> comparator) {
            this.component = ResourceUtil.getText(key);
            this.tooltip = class_7919.method_47407(this.component);
            this.sprites = ButtonSprites.of(new Sprite(ResourceUtil.getIcon(icon), Size.of16()));
            this.comparator = folderFirst(comparator);
        }

        @Override
        public @NonNull class_2561 text() {
            return this.component;
        }

        @Override
        public @Nullable class_7919 tooltip() {
            return this.tooltip;
        }

        @Override
        public @Nullable ButtonSprites sprites() {
            return this.sprites;
        }

        static Comparator<class_3288> folderFirst(Comparator<class_3288> base) {
            return Comparator.comparing((class_3288 pack) -> !(pack instanceof FolderPack)).thenComparing(base);
        }

        public static SortOption getOrDefault(String name) {
            if (name == null) {
                return VANILLA;
            }

            try {
                return valueOf(name);
            } catch (IllegalArgumentException e) {
                return VANILLA;
            }
        }
    }

    private static String normalizeTitle(String title) {
        return title
                .replaceAll("§.", "") // remove formatting
                .trim();
    }
}
