package io.github.fishstiz.packed_packs.gui.layouts.pack;

import io.github.fishstiz.fidgetz.gui.components.FidgetzButton;
import io.github.fishstiz.fidgetz.gui.components.ToggleableEditBox;
import io.github.fishstiz.fidgetz.gui.layouts.FlexLayout;
import io.github.fishstiz.packed_packs.gui.components.pack.PackList;
import io.github.fishstiz.packed_packs.util.ResourceUtil;
import net.minecraft.class_5244;
import net.minecraft.class_7919;
import net.minecraft.class_8030;
import org.jspecify.annotations.NonNull;

import static io.github.fishstiz.packed_packs.util.constants.GuiConstants.SPACING;

public abstract class PackLayout {
    protected final PackList list;
    private final ToggleableEditBox<Void> searchField;
    private final FidgetzButton<Void> transferButton;
    private FlexLayout headerLayout;
    private FlexLayout layout;

    protected PackLayout(PackList list) {
        this.list = list;
        this.searchField = ToggleableEditBox.<Void>builder()
                .setHint(ResourceUtil.getText("search").method_10852(class_5244.field_39678))
                .setEditable(true)
                .addListener(this.list::search)
                .build();
        this.transferButton = FidgetzButton.<Void>builder()
                .makeSquare()
                .setOnPress(this.list::transferAll)
                .setTooltip(class_7919.method_47407(ResourceUtil.getText("transfer_all.info")))
                .build();
    }

    protected abstract void initHeader(@NonNull FlexLayout header);

    public final void init(@NonNull FlexLayout layout) {
        this.headerLayout = FlexLayout.horizontal(this.list::method_25368).spacing(SPACING);
        this.initHeader(headerLayout);

        this.layout = layout;
        this.layout.addChild(headerLayout);
        this.layout.addFlexChild(this.list, true);
    }

    public PackList list() {
        return this.list;
    }

    public ToggleableEditBox<Void> getSearchField() {
        return this.searchField;
    }

    public FidgetzButton<Void> getTransferButton() {
        return this.transferButton;
    }

    public void setHeaderVisibility(boolean visible) {
        if (layout == null) return;

        this.headerLayout.method_48206(widget -> widget.field_22764 = visible);

        class_8030 headerRect = this.headerLayout.method_48202();
        int y = visible ? headerRect.method_49619() + SPACING : headerRect.method_49618();
        int height = visible ? layout.method_25364() - headerRect.comp_1197() - SPACING : layout.method_25364();

        this.list.method_46419(y);
        this.list.method_53533(height);
        this.list.clampScrollAmount();
    }
}
