package io.github.fishstiz.packed_packs.transform.mixin.gui;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import io.github.fishstiz.fidgetz.gui.components.FidgetzButton;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.Sprite;
import io.github.fishstiz.fidgetz.gui.shapes.Size;
import io.github.fishstiz.packed_packs.gui.metadata.PackSelectionScreenArgs;
import io.github.fishstiz.packed_packs.gui.screens.PackedPacksScreen;
import io.github.fishstiz.packed_packs.gui.metadata.GridWrapper;
import io.github.fishstiz.packed_packs.transform.mixin.PackSelectionScreenAccessor;
import io.github.fishstiz.packed_packs.util.ResourceUtil;
import org.jspecify.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.nio.file.Path;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_3283;
import net.minecraft.class_437;
import net.minecraft.class_5375;
import net.minecraft.class_7919;
import net.minecraft.class_8667;

@Mixin(class_5375.class)
public abstract class PackSelectionScreenMixin extends class_437 implements PackSelectionScreenAccessor {
    protected PackSelectionScreenMixin(class_2561 title) {
        super(title);
    }

    @Unique
    private PackSelectionScreenArgs packed_packs$original;

    @Unique
    private FidgetzButton<GridWrapper<class_8667>> packed_packs$button;

    @Unique
    private class_437 packed_packs$previous;

    @Override
    public void packed_packs$setPrevious(class_437 previous) {
        this.packed_packs$previous = previous;
    }

    @Override
    public @Nullable class_437 packed_packs$getPrevious() {
        return this.packed_packs$previous;
    }

    @Inject(method = "<init>", at = @At("TAIL"))
    private void setRepository(class_3283 repository, Consumer<class_3283> output, Path packDir, class_2561 title, CallbackInfo ci) {
        this.packed_packs$original = new PackSelectionScreenArgs(repository, output, packDir, title);
    }

    @WrapOperation(
            method = "init",
            slice = @Slice(from = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/gui/layouts/HeaderAndFooterLayout;addToContents(Lnet/minecraft/client/gui/layouts/LayoutElement;)Lnet/minecraft/client/gui/layouts/LayoutElement;"
            )),
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/gui/layouts/LinearLayout;spacing(I)Lnet/minecraft/client/gui/layouts/LinearLayout;",
                    ordinal = 0
            )
    )
    public class_8667 addPackedPacksButton(class_8667 instance, int spacing, Operation<class_8667> original) {
        class_437 previous = this.packed_packs$previous != null ? this.packed_packs$previous : this;
        this.packed_packs$button = FidgetzButton.<GridWrapper<class_8667>>builder()
                .makeSquare()
                .setTooltip(class_7919.method_47407(ResourceUtil.getModName()))
                .setSprite(new Sprite(ResourceUtil.getIcon("packed_packs"), Size.of16()))
                .setOnPress(() -> this.field_22787.method_1507(new PackedPacksScreen(previous, this.packed_packs$original)))
                .setMetadata(new GridWrapper<>(original.call(instance, spacing), spacing))
                .build();

        this.method_37063(this.packed_packs$button);
        return this.packed_packs$button.getMetadata().layout();
    }

    @Inject(method = "repositionElements", at = @At("TAIL"))
    public void repositionPackedPacksButton(CallbackInfo ci) {
        if (this.packed_packs$button != null) {
            GridWrapper<class_8667> layoutData = this.packed_packs$button.getMetadata();
            int x = layoutData.layout().method_46426() - this.packed_packs$button.method_25368() - layoutData.spacing();
            this.packed_packs$button.method_48229(x, layoutData.layout().method_46427());
        }
    }
}
