package io.github.fishstiz.packed_packs.transform.mixin.overrides;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import io.github.fishstiz.packed_packs.config.Profile;
import io.github.fishstiz.packed_packs.pack.PackOptionsResolver;
import io.github.fishstiz.packed_packs.transform.interfaces.ConfiguredPack;
import net.minecraft.class_3281;
import net.minecraft.class_3288;
import net.minecraft.class_9225;
import org.jspecify.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(class_3288.class)
public abstract class PackMixin implements ConfiguredPack {
    @Shadow
    @Final
    private class_3288.class_7679 metadata;

    @Shadow
    @Final
    private class_9225 selectionConfig;

    @Unique
    @Nullable
    private PackOptionsResolver packed_packs$resolver;

    @Override
    public void packed_packs$setConfigurationResolver(PackOptionsResolver resolver) {
        this.packed_packs$resolver = resolver;
    }

    @Override
    public boolean packed_packs$isHidden() {
        return this.packed_packs$resolver != null && this.packed_packs$resolver.isHidden(self());
    }

    @Unique
    private class_3288 self() {
        return (class_3288) (Object) this;
    }

    @WrapMethod(method = "isRequired")
    private boolean resolveRequired(Operation<Boolean> original) {
        PackOptionsResolver resolver = this.packed_packs$resolver;
        if (resolver != null && resolver.overridesRequired(self())) {
            return resolver.isRequired(self());
        }
        return original.call();
    }

    @WrapMethod(method = "isFixedPosition")
    private boolean resolveFixed(Operation<Boolean> original) {
        PackOptionsResolver resolver = this.packed_packs$resolver;
        if (resolver != null && resolver.overridesPosition(self())) {
            return resolver.isFixed(self());
        }
        return original.call();
    }

    @WrapMethod(method = "getDefaultPosition")
    private class_3288.class_3289 resolvePosition(Operation<class_3288.class_3289> original) {
        if (this.packed_packs$resolver != null) {
            class_3288.class_3289 position = this.packed_packs$resolver.getPosition(self());
            if (position != null) {
                return position;
            }
        }
        return original.call();
    }

    @WrapMethod(method = "selectionConfig")
    private class_9225 resolveSelectionConfig(Operation<class_9225> original) {
        if (this.packed_packs$resolver != null) {
            class_9225 selectionConfig = this.packed_packs$resolver.getSelectionConfig(self());
            if (selectionConfig != null) {
                return selectionConfig;
            }
        }
        return original.call();
    }

    @WrapMethod(method = "getCompatibility")
    private class_3281 resolveCompatibility(Operation<class_3281> original) {
        if (this.packed_packs$resolver != null) {
            Profile defaultProfile = this.packed_packs$resolver.config().getDefaultProfile();
            if (defaultProfile != null && defaultProfile.includes(self())) {
                return class_3281.field_14224;
            }
        }
        return original.call();
    }

    @Override
    public boolean packed_packs$isConfigured() {
        if (this.packed_packs$resolver != null) {
            Profile defaultProfile = this.packed_packs$resolver.config().getDefaultProfile();
            return defaultProfile != null && defaultProfile.includes(self());
        }

        return false;
    }

    @Override
    public class_3288.class_7679 packed_packs$getMetadata() {
        return this.metadata;
    }

    @Override
    public class_9225 packed_packs$originalConfig() {
        return this.selectionConfig;
    }
}
