/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.fidgetz.gui.components;

import io.github.fishstiz.fidgetz.gui.components.FidgetzButton;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.ButtonSprites;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CyclicButton<T extends Option, E>
extends FidgetzButton<E> {
    @Nullable
    private final class_2561 prefix;
    private final List<Consumer<T>> listeners;
    private final T[] options;
    private int value = 0;

    private CyclicButton(Builder<T, E> builder) {
        super(builder);
        this.listeners = builder.listeners;
        this.options = builder.options;
        this.prefix = builder.prefix;
        this.setValueSilently(builder.value);
    }

    private void setValue(T value, boolean silent) {
        for (int i = 0; i < this.options.length; ++i) {
            if (this.options[i] != value) continue;
            this.value = i;
            break;
        }
        if (!silent) {
            this.informListeners();
        }
        this.updateMessage();
    }

    public void setValue(T value) {
        this.setValue(value, false);
    }

    public void setValueSilently(T value) {
        this.setValue(value, true);
    }

    public T getValue() {
        return this.options[this.value];
    }

    @Override
    public void method_25306() {
        this.value = this.value >= this.options.length - 1 ? 0 : this.value + 1;
        this.updateMessage();
        this.informListeners();
    }

    private void updateMessage() {
        this.method_25355((class_2561)(this.prefix != null ? this.prefix.method_27661().method_27693(": ").method_10852(this.getValue().text()) : this.getValue().text()));
        this.method_47400(this.getValue().tooltip());
    }

    private void informListeners() {
        T option = this.getValue();
        for (Consumer<T> listener : this.listeners) {
            listener.accept(option);
        }
    }

    public void addListener(Consumer<T> listener) {
        this.listeners.add(listener);
    }

    @Override
    protected boolean hasSprite() {
        return super.hasSprite() || this.getValue() instanceof SpriteOption;
    }

    @Override
    protected void renderSprite(class_332 guiGraphics, int x, int y, int width, int height, float partialTick) {
        T t = this.getValue();
        if (!(t instanceof SpriteOption)) {
            super.renderSprite(guiGraphics, x, y, width, height, partialTick);
            return;
        }
        SpriteOption spriteOption = (SpriteOption)t;
        ButtonSprites sprites = spriteOption.sprites();
        if (sprites != null) {
            sprites.get(this.field_22763).renderClamped(guiGraphics, x, y, width, height, partialTick);
        }
    }

    public static <E> Builder<Option, E> builder(class_2561 ... components) {
        Option[] options = new Option[components.length];
        for (int i = 0; i < components.length; ++i) {
            options[i] = Option.create(components[i]);
        }
        return new Builder(options);
    }

    public static <T extends Option, E> Builder<T, E> builder(T[] options) {
        return new Builder(options);
    }

    public static class Builder<T extends Option, E>
    extends FidgetzButton.Builder<E, Builder<T, E>> {
        private final List<Consumer<T>> listeners = new ArrayList<Consumer<T>>();
        private final T[] options;
        private T value;
        private class_2561 prefix;

        private Builder(T[] options) {
            this.options = options;
        }

        public Builder<T, E> setValue(T value) {
            this.value = value;
            return this;
        }

        public Builder<T, E> setPrefix(class_2561 prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder<T, E> addListener(Consumer<T> listener) {
            this.listeners.add(listener);
            return this;
        }

        public CyclicButton<T, E> build() {
            return new CyclicButton(this);
        }
    }

    public static interface Option {
        @NotNull
        public class_2561 text();

        @Nullable
        default public class_7919 tooltip() {
            return null;
        }

        public static Option create(class_2561 component) {
            return () -> component;
        }
    }

    public static interface SpriteOption
    extends Option {
        @Nullable
        public ButtonSprites sprites();
    }
}

