/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.fidgetz.gui.components;

import io.github.fishstiz.fidgetz.gui.Metadata;
import io.github.fishstiz.fidgetz.gui.WidgetBuilder;
import io.github.fishstiz.fidgetz.gui.components.ToggleableDialogContainer;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.ButtonSprites;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.Sprite;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;

public class FidgetzButton<E>
extends class_4185
implements Metadata<E> {
    private final List<Runnable> listeners = new ArrayList<Runnable>();
    private final ButtonSprites sprites;
    private E metadata;

    protected FidgetzButton(Builder<E, ?> builder) {
        super(builder.x, builder.y, builder.width, builder.height, builder.message, builder.onPress, field_40754);
        this.metadata = builder.metadata;
        this.sprites = builder.sprites;
        if (builder.tooltip != null) {
            this.method_47400(builder.tooltip);
        }
    }

    public void method_25306() {
        super.method_25306();
        for (Runnable listener : this.listeners) {
            listener.run();
        }
    }

    public void addListener(Runnable listener) {
        this.listeners.add(listener);
    }

    @Override
    public E getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(E metadata) {
        this.metadata = metadata;
    }

    protected boolean hasSprite() {
        return this.sprites != null;
    }

    protected void renderSprite(class_332 guiGraphics, int x, int y, int width, int height, float partialTick) {
        this.sprites.get(this.field_22763).renderClamped(guiGraphics, x, y, width, height, partialTick);
    }

    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.field_22762 = this.method_25405(mouseX, mouseY);
        super.method_48579(guiGraphics, mouseX, mouseY, partialTick);
        if (this.hasSprite()) {
            int spriteWidth = this.method_25368();
            int spriteHeight = this.method_25364();
            int spriteX = this.method_46426() + (this.method_25368() - spriteWidth) / 2;
            int spriteY = this.method_46427() + (this.method_25364() - spriteHeight) / 2;
            this.renderSprite(guiGraphics, spriteX, spriteY, spriteWidth, spriteHeight, partialTick);
        }
    }

    public void method_48589(class_332 guiGraphics, class_327 font, int color) {
        if (!this.hasSprite()) {
            super.method_48589(guiGraphics, font, color);
        }
    }

    public boolean method_25405(double mouseX, double mouseY) {
        boolean isMouseOver = super.method_25405(mouseX, mouseY);
        boolean isCoveredAtPoint = false;
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (class_4372 instanceof ToggleableDialogContainer) {
            ToggleableDialogContainer dialogContainer = (ToggleableDialogContainer)class_4372;
            isCoveredAtPoint = dialogContainer.isChildCoveredAtPoint((class_364)this, mouseX, mouseY);
        }
        return isMouseOver && !isCoveredAtPoint;
    }

    public static <E> Builder<E, ?> builder() {
        return new Builder();
    }

    public static class Builder<E, B extends Builder<E, B>>
    implements WidgetBuilder<Builder<E, B>> {
        private int x = 0;
        private int y = 0;
        private int width = 150;
        private int height = 20;
        private class_2561 message = class_2561.method_43473();
        private class_7919 tooltip;
        private ButtonSprites sprites;
        private class_4185.class_4241 onPress = btn -> {};
        private E metadata;

        protected Builder() {
        }

        protected B self() {
            return (B)this;
        }

        @Override
        @NotNull
        public B setX(int x) {
            this.x = x;
            return this.self();
        }

        @Override
        @NotNull
        public B setY(int y) {
            this.y = y;
            return this.self();
        }

        @Override
        @NotNull
        public B setPosition(int x, int y) {
            this.x = x;
            this.y = y;
            return this.self();
        }

        @Override
        @NotNull
        public B setWidth(int width) {
            this.width = width;
            return this.self();
        }

        @Override
        @NotNull
        public B setHeight(int height) {
            this.height = height;
            return this.self();
        }

        @Override
        @NotNull
        public B setDimensions(int width, int height) {
            this.width = width;
            this.height = height;
            return this.self();
        }

        public B makeSquare(int size) {
            this.height = size;
            this.width = size;
            return this.self();
        }

        public B makeSquare() {
            return this.makeSquare(this.height);
        }

        public B setMessage(class_2561 message) {
            this.message = message;
            return this.self();
        }

        public B setMessage(String message) {
            return this.setMessage((class_2561)class_2561.method_43471((String)message));
        }

        public B setTooltip(class_7919 tooltip) {
            this.tooltip = tooltip;
            return this.self();
        }

        public B setSpriteOnly(ButtonSprites sprites) {
            this.sprites = sprites;
            return this.self();
        }

        public B setSpriteOnly(Sprite sprite) {
            this.sprites = ButtonSprites.of(sprite);
            return this.self();
        }

        public B setOnPress(class_4185.class_4241 onPress) {
            this.onPress = onPress;
            return this.self();
        }

        public B setOnPress(Runnable onPress) {
            this.onPress = btn -> onPress.run();
            return this.self();
        }

        public B setMetadata(E metadata) {
            this.metadata = metadata;
            return this.self();
        }

        public FidgetzButton<E> build() {
            return new FidgetzButton(this);
        }
    }
}

