/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.fidgetz.gui.components;

import io.github.fishstiz.fidgetz.gui.components.FidgetzButton;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.ButtonSprites;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.Sprite;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5244;

public class ToggleButton<E>
extends FidgetzButton<E> {
    private final List<Consumer<Boolean>> listeners;
    private final boolean prefixMessage;
    private final Sprites toggleSprites;
    private class_2561 prefix;
    private boolean value;

    protected ToggleButton(ToggleBuilder<E> builder) {
        super(builder);
        this.toggleSprites = builder.toggleSprites;
        this.listeners = builder.listeners;
        this.prefixMessage = builder.prefixMessage;
        this.value = builder.value;
        this.prefix = this.method_25369();
        this.updateMessage();
    }

    private void setValue(boolean value, boolean silent) {
        this.value = value;
        if (!silent) {
            for (Consumer<Boolean> listener : this.listeners) {
                listener.accept(this.getValue());
            }
        }
        this.updateMessage();
    }

    public void setValue(boolean value) {
        this.setValue(value, false);
    }

    public void setValueSilently(boolean value) {
        this.setValue(value, true);
    }

    public boolean getValue() {
        return this.value;
    }

    public void method_25348(double mouseX, double mouseY) {
        super.method_25348(mouseX, mouseY);
        this.setValue(!this.getValue());
    }

    public void addListener(Consumer<Boolean> listener) {
        this.listeners.add(listener);
    }

    public void method_25355(class_2561 message) {
        this.prefix = message;
        this.updateMessage();
    }

    public class_2561 getPrefix() {
        return this.prefix;
    }

    private void updateMessage() {
        class_2561 valueText;
        class_2561 class_25612 = valueText = this.getValue() ? class_5244.field_24332 : class_5244.field_24333;
        if (this.prefixMessage) {
            super.method_25355((class_2561)this.getPrefix().method_27661().method_27693(": ").method_10852(valueText));
        } else {
            super.method_25355(valueText);
        }
    }

    @Override
    protected boolean hasSprite() {
        return super.hasSprite() || this.toggleSprites != null;
    }

    @Override
    protected void renderSprite(class_332 guiGraphics, int x, int y, int width, int height, float partialTick) {
        if (this.toggleSprites == null) {
            super.renderSprite(guiGraphics, x, y, width, height, partialTick);
            return;
        }
        this.toggleSprites.get(this.value, this.field_22763).renderClamped(guiGraphics, x, y, width, height, partialTick);
    }

    public static <E> ToggleBuilder<E> builder() {
        return new ToggleBuilder();
    }

    public static class ToggleBuilder<E>
    extends FidgetzButton.Builder<E, ToggleBuilder<E>> {
        private final List<Consumer<Boolean>> listeners = new ArrayList<Consumer<Boolean>>();
        private boolean value = false;
        private boolean prefixMessage = true;
        private Sprites toggleSprites;

        protected ToggleBuilder() {
        }

        public ToggleBuilder<E> setValue(boolean value) {
            this.value = value;
            return this;
        }

        public ToggleBuilder<E> setPrefixMessage(boolean prefixMessage) {
            this.prefixMessage = prefixMessage;
            return this;
        }

        public ToggleBuilder<E> addListener(Consumer<Boolean> listener) {
            this.listeners.add(listener);
            return this;
        }

        public ToggleBuilder<E> setSpriteOnly(Sprites toggleSprites) {
            this.toggleSprites = toggleSprites;
            return this;
        }

        @Override
        public ToggleButton<E> build() {
            return new ToggleButton(this);
        }
    }

    public record Sprites(ButtonSprites toggled, ButtonSprites untoggled) {
        public static Sprites of(Sprite toggled, Sprite untoggled) {
            return new Sprites(ButtonSprites.of(toggled), ButtonSprites.of(untoggled));
        }

        public Sprite get(boolean toggled, boolean active) {
            return this.get(toggled).get(active);
        }

        public ButtonSprites get(boolean toggled) {
            return toggled ? this.toggled : this.untoggled;
        }
    }
}

