/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.fidgetz.gui.components;

import io.github.fishstiz.fidgetz.gui.Metadata;
import io.github.fishstiz.fidgetz.gui.WidgetBuilder;
import io.github.fishstiz.fidgetz.transform.interfaces.TextRenderer;
import io.github.fishstiz.fidgetz.transform.mixin.EditBoxAccess;
import io.github.fishstiz.fidgetz.util.LogUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_342;
import org.jetbrains.annotations.NotNull;

public class ToggleableEditBox<E>
extends class_342
implements Metadata<E> {
    private static final int DEFAULT_MAX_LENGTH = 32;
    private final List<Consumer<String>> listeners = new ArrayList<Consumer<String>>();
    private final int hintColor;
    private E metadata;
    private int focusedTextColor;
    private String previousValue;

    private ToggleableEditBox(Builder<E> builder) {
        super(builder.font, builder.x, builder.y, builder.width, builder.height, (class_2561)class_2561.method_43470((String)builder.value));
        this.hintColor = builder.hintColor != null ? builder.hintColor.intValue() : ((EditBoxAccess)((Object)this)).getTextColorUneditable();
        this.focusedTextColor = builder.textColor != null ? builder.textColor.intValue() : ((EditBoxAccess)((Object)this)).getTextColor();
        this.previousValue = builder.value;
        this.metadata = builder.metadata;
        if (builder.filter != null) {
            this.method_1890(builder.filter);
        }
        this.method_1852(builder.value);
        this.method_1888(builder.editable);
        this.method_47404(builder.hint);
        this.method_1880(builder.maxLength);
        ((TextRenderer)((Object)this)).fidgetz$setShadow(builder.textShadow);
        this.updateTextColor();
        this.listeners.addAll(builder.listeners);
        super.method_1863(this::onRespond);
    }

    public void toggle() {
        this.method_1888(!this.isEditing());
    }

    public boolean isEditing() {
        return ((EditBoxAccess)((Object)this)).invokeIsEditable();
    }

    public void method_1888(boolean enabled) {
        super.method_1888(enabled);
        this.method_1870(false);
        this.field_22763 = enabled;
    }

    public void method_1868(int color) {
        super.method_1868(color);
        this.method_1860(color);
        this.focusedTextColor = color;
    }

    private void updateTextColor() {
        int color = !this.method_1882().isEmpty() || this.method_25370() ? this.focusedTextColor : this.hintColor;
        super.method_1868(color);
        this.method_1860(color);
    }

    private void onRespond(String value) {
        this.updateTextColor();
        if (!Objects.equals(this.previousValue, value)) {
            this.previousValue = value;
            for (Consumer<String> listener : this.listeners) {
                listener.accept(value);
            }
        }
    }

    public final void method_1863(Consumer<String> responder) {
        LogUtil.logUnsupported("Use addListener instead of setResponder.");
    }

    public void addListener(Consumer<String> listener) {
        this.listeners.add(listener);
    }

    public boolean method_1851() {
        return this.isEditing();
    }

    public boolean method_25370() {
        return this.isEditing() && super.method_25370();
    }

    public void method_25365(boolean focused) {
        super.method_25365(focused);
        this.updateTextColor();
    }

    public boolean method_49606() {
        return this.isEditing() && super.method_49606();
    }

    public boolean method_37303() {
        return this.isEditing() && this.field_22763;
    }

    public void method_25348(double mouseX, double mouseY) {
        if (this.isEditing()) {
            super.method_25348(mouseX, mouseY);
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 263 && (this.method_1882().isEmpty() || this.method_1881() == 0)) {
            return false;
        }
        if (keyCode == 262 && (this.method_1882().isEmpty() || this.method_1881() == this.method_1882().length())) {
            return false;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    public E getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(E metadata) {
        this.metadata = metadata;
    }

    public static <E> Builder<E> builder(class_327 font) {
        return new Builder(font);
    }

    public static <E> Builder<E> builder() {
        return ToggleableEditBox.builder(class_310.method_1551().field_1772);
    }

    public static class Builder<E>
    implements WidgetBuilder<Builder<E>> {
        private final class_327 font;
        private final List<Consumer<String>> listeners = new ArrayList<Consumer<String>>();
        private int x = 0;
        private int y = 0;
        private int width = 150;
        private int height = 20;
        private String value = "";
        private class_2561 hint;
        private boolean textShadow = true;
        private Integer textColor;
        private Integer hintColor;
        private boolean editable = false;
        private int maxLength = 32;
        private Predicate<String> filter;
        private E metadata;

        private Builder(class_327 font) {
            this.font = font;
        }

        @Override
        @NotNull
        public Builder<E> setX(int x) {
            this.x = x;
            return this;
        }

        @Override
        @NotNull
        public Builder<E> setY(int y) {
            this.y = y;
            return this;
        }

        @Override
        @NotNull
        public Builder<E> setPosition(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        @Override
        @NotNull
        public Builder<E> setWidth(int width) {
            this.width = width;
            return this;
        }

        @Override
        @NotNull
        public Builder<E> setHeight(int height) {
            this.height = height;
            return this;
        }

        @Override
        @NotNull
        public Builder<E> setDimensions(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder<E> setValue(String value) {
            this.value = value;
            return this;
        }

        public Builder<E> setHint(class_2561 hint) {
            this.hint = hint;
            return this;
        }

        public Builder<E> setEditable(boolean editable) {
            this.editable = editable;
            return this;
        }

        public Builder<E> setTextShadow(boolean textShadow) {
            this.textShadow = textShadow;
            return this;
        }

        public Builder<E> setTextColor(Integer textColor) {
            this.textColor = textColor;
            return this;
        }

        public Builder<E> setHintColor(Integer hintColor) {
            this.hintColor = hintColor;
            return this;
        }

        public Builder<E> setMaxLength(int maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public Builder<E> setFilter(Predicate<String> filter) {
            this.filter = filter;
            return this;
        }

        public Builder<E> addListener(Consumer<String> listener) {
            this.listeners.add(listener);
            return this;
        }

        public Builder<E> setMetadata(E metadata) {
            this.metadata = metadata;
            return this;
        }

        public ToggleableEditBox<E> build() {
            return new ToggleableEditBox(this);
        }
    }
}

