/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.fidgetz.util.debounce;

import io.github.fishstiz.fidgetz.util.debounce.Debouncer;
import java.util.function.Consumer;
import net.minecraft.class_156;

public class PollingDebouncer<T>
extends Debouncer<T> {
    private boolean pending = false;
    private long lastCallTime = 0L;
    private T lastArg = null;

    public PollingDebouncer(Consumer<T> task, long delay) {
        super(task, delay);
    }

    public PollingDebouncer(Runnable task, long delay) {
        super(task, delay);
    }

    @Override
    public void accept(T t) {
        this.lastCallTime = class_156.method_658();
        this.pending = true;
        this.lastArg = t;
    }

    public void abort() {
        this.pending = false;
    }

    public void poll() {
        if (this.pending && class_156.method_658() - this.lastCallTime >= this.delay) {
            try {
                this.task.accept(this.lastArg);
            }
            finally {
                this.pending = false;
            }
        }
    }
}

