/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.compat.minecraftcursor;

import io.github.fishstiz.fidgetz.gui.components.Modal;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.api.CursorTypeRegistrar;
import io.github.fishstiz.minecraftcursor.api.ElementRegistrar;
import io.github.fishstiz.minecraftcursor.api.MinecraftCursorInitializer;
import io.github.fishstiz.packed_packs.gui.components.pack.AvailablePackList;
import io.github.fishstiz.packed_packs.gui.components.pack.CurrentPackList;
import io.github.fishstiz.packed_packs.gui.screens.PackedPacksScreen;
import net.minecraft.class_8667;

public class PackedPacksMinecraftCursor
implements MinecraftCursorInitializer {
    public void init(CursorTypeRegistrar cursorRegistrar, ElementRegistrar elementRegistrar) {
        elementRegistrar.register(AvailablePackList.Entry.class, this::getCursorType);
        elementRegistrar.register(CurrentPackList.Entry.class, this::getCursorType);
        elementRegistrar.register(PackedPacksScreen.class, this::getCursorType);
    }

    private CursorType getCursorType(AvailablePackList.Entry entry, double mouseX, double mouseY) {
        return entry.isMouseOverSelect(mouseX, mouseY) ? CursorType.POINTER : CursorType.DEFAULT;
    }

    private CursorType getCursorType(CurrentPackList.Entry entry, double mouseX, double mouseY) {
        if (entry.isMouseOverRemove(mouseX, mouseY) || entry.isMouseOverUp(mouseX, mouseY) || entry.isMouseOverDown(mouseX, mouseY)) {
            return CursorType.POINTER;
        }
        return CursorType.DEFAULT;
    }

    private CursorType getCursorType(PackedPacksScreen screen, double mouseX, double mouseY) {
        Modal<class_8667> options = screen.getOptionsDialog();
        if (options.isOpen() && !options.isHovered()) {
            return CursorType.DEFAULT_FORCE;
        }
        return screen.isDraggingSelection() ? CursorType.GRABBING : CursorType.DEFAULT;
    }
}

