/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.github.fishstiz.packed_packs.PackedPacks;
import io.github.fishstiz.packed_packs.config.Config;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class ConfigLoader {
    private static final Gson GSON = new GsonBuilder().serializeNulls().setPrettyPrinting().create();

    private ConfigLoader() {
    }

    public static Config load(File file) {
        Config config = new Config();
        try (FileReader reader = new FileReader(file);){
            config = (Config)GSON.fromJson((Reader)reader, Config.class);
        }
        catch (FileNotFoundException e) {
            PackedPacks.LOGGER.info("[packed_packs] Creating config at '{}'...", (Object)file.getPath());
            ConfigLoader.save(config, file);
        }
        catch (IOException e) {
            PackedPacks.LOGGER.error("[packed_packs] Failed to load config at '{}'.", (Object)file.getPath());
        }
        config.file = file;
        return config;
    }

    public static void save(Config config, File file) {
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson((Object)config, (Appendable)writer);
        }
        catch (IOException e) {
            PackedPacks.LOGGER.info("[packed_packs] Failed to save config at '{}'.", (Object)file.getPath());
        }
    }
}

