/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.config;

import io.github.fishstiz.packed_packs.util.ResourceUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_3288;

public class Profile
implements Serializable {
    public static final int NAME_MAX_LENGTH = 32;
    private long id;
    private String name;
    private List<String> packIds = new ArrayList<String>();

    public Profile(String name) {
        this.name = Profile.trimName(name);
    }

    private Profile(String name, List<String> packIds) {
        this(name);
        this.packIds = List.copyOf(packIds);
    }

    void setId(long id) {
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = Profile.trimName(name);
    }

    public List<String> getPackIds() {
        return this.packIds;
    }

    public void setPacks(List<class_3288> packs) {
        ArrayList<String> ids = new ArrayList<String>();
        for (class_3288 pack : packs) {
            if (pack == null) continue;
            ids.add(pack.method_14463());
        }
        this.packIds = ids;
    }

    public Profile copy() {
        Object profileName = this.name;
        if (profileName != null && !((String)profileName).isBlank()) {
            profileName = (String)profileName + " - " + ResourceUtil.getText("profile.copy", new Object[0]).getString();
        }
        return new Profile((String)profileName, this.packIds);
    }

    private static String trimName(String name) {
        if (name == null) {
            return null;
        }
        return name.length() <= 32 ? name : name.substring(0, 32);
    }
}

