/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.gui.components.pack;

import com.google.common.collect.ImmutableList;
import io.github.fishstiz.fidgetz.gui.renderables.ColoredRect;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.Sprite;
import io.github.fishstiz.fidgetz.util.GuiUtil;
import io.github.fishstiz.packed_packs.gui.components.events.PackListEventListener;
import io.github.fishstiz.packed_packs.gui.components.pack.PackList;
import io.github.fishstiz.packed_packs.gui.components.pack.PackListBase;
import io.github.fishstiz.packed_packs.util.InputUtil;
import io.github.fishstiz.packed_packs.util.ResourceUtil;
import io.github.fishstiz.packed_packs.util.constants.Theme;
import io.github.fishstiz.packed_packs.util.lang.ObjectsUtil;
import io.github.fishstiz.packed_packs.util.pack.PackIconCache;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_3288;
import net.minecraft.class_332;
import net.minecraft.class_350;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AvailablePackList
extends PackListBase<Entry> {
    private static final Sprite SELECT_HIGHLIGHTED_SPRITE = Sprite.of32(ResourceUtil.getVanillaSprite("transferable_list/select_highlighted"));
    private static final Sprite SELECT_SPRITE = Sprite.of32(ResourceUtil.getVanillaSprite("transferable_list/select"));
    private static final Theme DROP_ZONE_THEME = Theme.RED_700;
    private static final ColoredRect DROP_ZONE = new ColoredRect(DROP_ZONE_THEME.withAlpha(0.25f));

    public AvailablePackList(PackIconCache iconCache, PackListEventListener listener) {
        super(iconCache, listener);
    }

    @Override
    @NotNull
    protected Entry createEntry(class_3288 pack, int index) {
        return new Entry(this, pack, index);
    }

    private boolean isInvalidDrop(PackList source, ImmutableList<class_3288> payload, class_3288 trigger) {
        return source == this || payload.isEmpty() || !source.isTransferable(trigger);
    }

    @Override
    @Nullable
    protected List<class_3288> handleDrop(PackList source, ImmutableList<class_3288> payload, class_3288 trigger, double mouseX, double mouseY) {
        if (this.isInvalidDrop(source, payload, trigger)) {
            return null;
        }
        ArrayList<class_3288> dropped = new ArrayList<class_3288>();
        for (class_3288 pack : payload) {
            if (!source.isTransferable(pack)) continue;
            dropped.add(pack);
        }
        this.clearSelection();
        source.removeAll(dropped);
        this.addAll(dropped);
        this.selectAll(dropped);
        this.select(trigger);
        Optional.ofNullable((Entry)this.getEntry(trigger)).ifPresent(x$0 -> this.method_25328((class_350.class_351)x$0));
        return dropped;
    }

    @Override
    public void renderDroppableZone(class_332 guiGraphics, PackList source, ImmutableList<class_3288> payload, class_3288 trigger, int mouseX, int mouseY, float partialTick) {
        int width;
        if (this.isInvalidDrop(source, payload, trigger)) {
            return;
        }
        int n = width = this.method_44392() ? this.method_25368() - this.scrollbarOffset : this.method_25368();
        if (this.method_25405(mouseX, mouseY)) {
            DROP_ZONE.render(guiGraphics, this.method_46426(), this.method_46427(), width, this.method_25364(), partialTick);
        }
        guiGraphics.method_49601(this.method_46426(), this.method_46427(), width, this.method_25364(), DROP_ZONE_THEME.getARGB());
    }

    public class Entry
    extends PackListBase.Entry {
        private Entry(AvailablePackList this$0, class_3288 pack, int index) {
            super(this$0, pack, index);
        }

        @Override
        public boolean isTransferable() {
            return true;
        }

        public boolean isMouseOverSelect(double mouseX, double mouseY) {
            return GuiUtil.containsPoint(this.method_46426() + 2, this.method_46427(), AvailablePackList.SELECT_SPRITE.width, AvailablePackList.SELECT_SPRITE.height, mouseX, mouseY);
        }

        @Override
        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (InputUtil.isLeftClick(button) && this.isMouseOverSelect(mouseX, mouseY)) {
                GuiUtil.playClickSound();
                this.transfer();
                return false;
            }
            return super.method_25402(mouseX, mouseY, button);
        }

        @Override
        protected void renderForeground(class_332 guiGraphics, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            if (!this.method_25405(mouseX, mouseY) && !this.isSelectedLast()) {
                return;
            }
            int x = left + 2;
            OVERLAY.render(guiGraphics, x, top, AvailablePackList.SELECT_SPRITE.width, AvailablePackList.SELECT_SPRITE.height);
            ObjectsUtil.pick(!this.isMouseOverSelect(mouseX, mouseY), SELECT_SPRITE, SELECT_HIGHLIGHTED_SPRITE).render(guiGraphics, x, top);
        }
    }
}

