/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.gui.components.pack;

import com.google.common.collect.ImmutableList;
import io.github.fishstiz.packed_packs.gui.components.pack.Query;
import io.github.fishstiz.packed_packs.gui.history.Restorable;
import io.github.fishstiz.packed_packs.util.lang.ObjectsUtil;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_3288;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PackList
extends class_4069,
Restorable<Snapshot> {
    public void add(class_3288 var1);

    public void addAll(List<class_3288> var1);

    public boolean move(class_3288 var1, int var2);

    public boolean moveAll(List<class_3288> var1, int var2);

    public void remove(class_3288 var1);

    public void removeAll(List<class_3288> var1);

    public void unselect(class_3288 var1);

    public void select(class_3288 var1);

    public void selectAll(List<class_3288> var1);

    public void selectExclusive(class_3288 var1);

    public void selectRange(class_3288 var1);

    public void clearSelection();

    public void drop(PackList var1, ImmutableList<class_3288> var2, class_3288 var3, double var4, double var6);

    public void renderDroppableZone(class_332 var1, PackList var2, ImmutableList<class_3288> var3, class_3288 var4, int var5, int var6, float var7);

    @Nullable
    public Entry getSelected();

    @Nullable
    public Entry getEntry(class_3288 var1);

    default public boolean isTransferable(class_3288 pack) {
        return ObjectsUtil.testNullable(this.getEntry(pack), Entry::isTransferable);
    }

    @NotNull
    public ImmutableList<class_3288> copyPacks();

    @NotNull
    public ImmutableList<class_3288> copySelection();

    @NotNull
    public Query copyQuery();

    @Override
    @NotNull
    default public Snapshot captureState() {
        return new Snapshot(this, this.copyPacks(), this.copySelection(), this.copyQuery());
    }

    public static interface Entry
    extends class_364 {
        public boolean isTransferable();

        public class_3288 getPack();
    }

    public static final class Snapshot
    extends Record
    implements Restorable.Snapshot<Snapshot> {
        private final PackList target;
        private final ImmutableList<class_3288> packs;
        private final ImmutableList<class_3288> selection;
        private final Query query;

        public Snapshot(PackList target, ImmutableList<class_3288> packs, ImmutableList<class_3288> selection, Query query) {
            this.target = target;
            this.packs = packs;
            this.selection = selection;
            this.query = query;
        }

        public Snapshot validate(List<class_3288> validPacks) {
            ArrayList<class_3288> validated = new ArrayList<class_3288>((Collection<class_3288>)this.packs);
            validated.retainAll(validPacks);
            return new Snapshot(this.target, (ImmutableList<class_3288>)ImmutableList.copyOf(validated), this.selection, this.query);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Snapshot.class, "target;packs;selection;query", "target", "packs", "selection", "query"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Snapshot.class, "target;packs;selection;query", "target", "packs", "selection", "query"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Snapshot.class, "target;packs;selection;query", "target", "packs", "selection", "query"}, this, o);
        }

        public PackList target() {
            return this.target;
        }

        public ImmutableList<class_3288> packs() {
            return this.packs;
        }

        public ImmutableList<class_3288> selection() {
            return this.selection;
        }

        public Query query() {
            return this.query;
        }
    }
}

