/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.gui.components.pack;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.github.fishstiz.fidgetz.gui.components.AbstractDynamicList;
import io.github.fishstiz.fidgetz.gui.renderables.ColoredRect;
import io.github.fishstiz.fidgetz.util.GuiUtil;
import io.github.fishstiz.packed_packs.gui.components.events.DragEvent;
import io.github.fishstiz.packed_packs.gui.components.events.DropEvent;
import io.github.fishstiz.packed_packs.gui.components.events.MoveEvent;
import io.github.fishstiz.packed_packs.gui.components.events.PackListEvent;
import io.github.fishstiz.packed_packs.gui.components.events.PackListEventListener;
import io.github.fishstiz.packed_packs.gui.components.events.RequestTransferEvent;
import io.github.fishstiz.packed_packs.gui.components.events.SelectionEvent;
import io.github.fishstiz.packed_packs.gui.components.pack.PackList;
import io.github.fishstiz.packed_packs.gui.components.pack.PackWidget;
import io.github.fishstiz.packed_packs.gui.components.pack.Query;
import io.github.fishstiz.packed_packs.util.InputUtil;
import io.github.fishstiz.packed_packs.util.constants.Theme;
import io.github.fishstiz.packed_packs.util.lang.IntsUtil;
import io.github.fishstiz.packed_packs.util.lang.ObjectsUtil;
import io.github.fishstiz.packed_packs.util.pack.PackIconCache;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.class_156;
import net.minecraft.class_3288;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_4587;
import net.minecraft.class_6379;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PackListBase<T extends Entry>
extends AbstractDynamicList<T>
implements PackList {
    protected static final int OFFSET_Y = 2;
    protected static final int ITEM_HEIGHT = 32;
    protected static final int ROW_GAP = 3;
    protected final List<class_3288> packs = new ArrayList<class_3288>();
    private final List<class_3288> queried = new ArrayList<class_3288>();
    private final List<class_3288> selection = new ArrayList<class_3288>();
    private final PackListEventListener listener;
    private final PackIconCache iconCache;
    private final Query query = new Query();

    protected PackListBase(PackIconCache iconCache, PackListEventListener listener) {
        super(32, 6, 2, 3);
        this.iconCache = iconCache;
        this.listener = listener;
        this.queryPacks();
    }

    @NotNull
    protected abstract T createEntry(class_3288 var1, int var2);

    @Nullable
    public T getEntry(@Nullable class_3288 pack) {
        if (pack == null) {
            return null;
        }
        for (Entry entry : this.method_25396()) {
            if (entry.pack != pack) continue;
            return (T)entry;
        }
        return null;
    }

    protected void refreshEntries() {
        this.method_25339();
        for (int i = 0; i < this.queried.size(); ++i) {
            this.method_25321((class_350.class_351)this.createEntry(this.queried.get(i), i));
        }
        Entry focused = (Entry)this.method_25336();
        if (focused != null && !this.queried.contains(focused.pack)) {
            this.method_25395(null);
        }
        this.clampScrollAmount();
    }

    public boolean isQueried() {
        return this.query.isQuerying();
    }

    protected void queryPacks() {
        this.queried.clear();
        this.queried.addAll(this.packs);
        this.query.apply(this.queried);
        this.selection.retainAll(this.queried);
        this.refreshEntries();
    }

    public void scrollToTop() {
        this.method_44382(0.0);
    }

    public void reload(Collection<class_3288> packs) {
        this.packs.clear();
        for (class_3288 pack : packs) {
            if (pack == null || this.packs.contains(pack)) continue;
            this.packs.add(pack);
        }
        this.method_25395(null);
        this.clearSelection();
        this.queryPacks();
        this.scrollToTop();
    }

    @Override
    @NotNull
    public ImmutableList<class_3288> copyPacks() {
        return ImmutableList.copyOf(this.packs);
    }

    @Override
    @NotNull
    public ImmutableList<class_3288> copySelection() {
        return ImmutableList.copyOf(this.selection);
    }

    @Override
    @NotNull
    public Query copyQuery() {
        return this.query.copy();
    }

    protected List<class_3288> orderSelection(List<class_3288> selection) {
        ArrayList<class_3288> sortedSelection = new ArrayList<class_3288>(selection);
        sortedSelection.retainAll(this.queried);
        sortedSelection.sort(Comparator.comparingInt(this.queried::indexOf));
        return sortedSelection;
    }

    public ImmutableList<class_3288> getOrderedSelection() {
        return ImmutableList.copyOf(this.orderSelection(this.selection));
    }

    protected int[] getIndicesFromSelection(List<class_3288> selection) {
        int[] selectionIndices = new int[selection.size()];
        for (int i = 0; i < selection.size(); ++i) {
            int index;
            selectionIndices[i] = index = this.queried.indexOf(selection.get(i));
        }
        return selectionIndices;
    }

    protected int[] getSelectionIndices() {
        return this.getIndicesFromSelection(this.selection);
    }

    @Override
    public void clearSelection() {
        this.selection.clear();
    }

    private void refresh() {
        this.clearSelection();
        this.queryPacks();
        this.scrollToTop();
    }

    public void sort(Query.SortOption sort) {
        if (this.query.setSort(sort)) {
            this.refresh();
        }
    }

    public void hideIncompatible(boolean hideIncompatible) {
        if (this.query.setHideIncompatible(hideIncompatible)) {
            this.clearSelection();
            this.queryPacks();
        }
    }

    public void search(@NotNull String search) {
        if (this.query.setSearch(search)) {
            this.refresh();
        }
    }

    private void addPack(class_3288 pack) {
        if (pack != null && !this.packs.contains(pack)) {
            int index = 0;
            for (class_3288 p : this.packs) {
                if (!p.method_14465()) break;
                ++index;
            }
            this.packs.add(index, pack);
        }
    }

    @Override
    public void add(class_3288 pack) {
        this.addPack(pack);
        this.queryPacks();
    }

    @Override
    public void addAll(List<class_3288> packs) {
        for (class_3288 pack : packs) {
            this.addPack(pack);
        }
        this.queryPacks();
    }

    @Override
    public boolean move(class_3288 pack, int to) {
        if (pack.method_14465()) {
            return false;
        }
        int from = this.packs.indexOf(pack);
        if (from == -1 || to < 0 || to >= this.packs.size() || from == to) {
            return false;
        }
        this.packs.remove(from);
        this.packs.add(to, pack);
        this.queryPacks();
        this.method_25395(this.getEntry(pack));
        return true;
    }

    @Override
    public boolean moveAll(List<class_3288> selection, int to) {
        if (selection == null || selection.isEmpty() || to < 0 || to > this.packs.size()) {
            return false;
        }
        if (!new HashSet<class_3288>(this.packs).containsAll(selection)) {
            return false;
        }
        int index = to;
        for (class_3288 pack : selection) {
            int from = this.packs.indexOf(pack);
            if (from >= to) continue;
            --index;
        }
        this.packs.removeAll(selection);
        this.packs.addAll(index, selection);
        this.queryPacks();
        return true;
    }

    private void removePack(class_3288 pack) {
        if (this.packs.remove(pack) && this.selection.remove(pack)) {
            this.method_25395(null);
        }
    }

    @Override
    public void remove(class_3288 pack) {
        this.removePack(pack);
        this.queryPacks();
    }

    @Override
    public void removeAll(List<class_3288> packs) {
        for (class_3288 pack : packs) {
            this.removePack(pack);
        }
        this.queryPacks();
    }

    @Nullable
    public class_3288 getLastSelected() {
        return !this.selection.isEmpty() ? this.selection.getLast() : null;
    }

    @Nullable
    public T getSelected() {
        return (T)(this.getLastSelected() != null ? this.getEntry(this.getLastSelected()) : (Entry)super.method_25334());
    }

    public boolean isSelected(class_3288 pack) {
        return this.selection.contains(pack);
    }

    public void scrollToLastSelected() {
        Optional.ofNullable(this.getEntry(this.getLastSelected())).ifPresent(x$0 -> this.method_25328((class_350.class_351)x$0));
    }

    @Override
    public void unselect(class_3288 pack) {
        this.selection.remove(pack);
        PackList.Entry entry = this.getEntry(pack);
        if (entry == this.method_25336()) {
            this.method_25395(null);
        }
        if (entry == this.getSelected()) {
            this.method_25313(null);
        }
    }

    @Override
    public void select(class_3288 pack) {
        if (pack != null && this.queried.contains(pack)) {
            this.selection.remove(pack);
            this.selection.add(pack);
            PackList.Entry entry = this.getEntry(pack);
            this.method_25395(entry);
            this.method_25313((class_350.class_351)entry);
        }
    }

    @Override
    public void selectAll(List<class_3288> packs) {
        for (class_3288 pack : packs) {
            this.select(pack);
        }
    }

    @Override
    public void selectExclusive(class_3288 pack) {
        this.clearSelection();
        this.select(pack);
    }

    public void selectToggle(class_3288 pack) {
        if (this.isSelected(pack)) {
            this.unselect(pack);
        } else {
            this.select(pack);
        }
    }

    @Override
    public void selectRange(class_3288 pack) {
        class_3288 selectionStart = this.getLastSelected();
        int lastSelectedIndex = this.queried.indexOf(selectionStart);
        int selectedPackIndex = this.queried.indexOf(pack);
        int[] selectionIndices = this.getSelectionIndices();
        Arrays.sort(selectionIndices);
        if (!Ints.contains((int[])selectionIndices, (int)-1) && !IntsUtil.hasGap(selectionIndices, true) && selectionIndices.length > 0) {
            if (selectionIndices[0] == lastSelectedIndex) {
                selectionStart = this.queried.get(selectionIndices[selectionIndices.length - 1]);
            } else if (selectionIndices[selectionIndices.length - 1] == lastSelectedIndex) {
                selectionStart = this.queried.get(selectionIndices[0]);
            }
        }
        int startIndex = this.queried.indexOf(selectionStart);
        if (selectedPackIndex != -1 && startIndex != -1) {
            this.clearSelection();
            for (int i = Math.min(selectedPackIndex, startIndex); i <= Math.max(selectedPackIndex, startIndex); ++i) {
                class_3288 selected = this.queried.get(i);
                if (selected == pack) continue;
                this.select(selected);
            }
        }
        this.select(pack);
    }

    public void transferAll() {
        ArrayList<class_3288> payload = new ArrayList<class_3288>();
        for (int i = this.queried.size() - 1; i >= 0; --i) {
            class_3288 pack = this.queried.get(i);
            if (!this.isTransferable(pack)) continue;
            payload.add(pack);
        }
        if (!payload.isEmpty()) {
            this.sendEvent(new RequestTransferEvent(this, payload, this.getLastSelected()));
        }
    }

    protected void sendEvent(PackListEvent event) {
        this.listener.onEvent(event);
    }

    @Nullable
    protected abstract List<class_3288> handleDrop(PackList var1, ImmutableList<class_3288> var2, class_3288 var3, double var4, double var6);

    @Override
    public final void drop(PackList source, ImmutableList<class_3288> selection, class_3288 trigger, double mouseX, double mouseY) {
        List<class_3288> dropped = this.handleDrop(source, selection, trigger, mouseX, mouseY);
        if (dropped != null && !dropped.isEmpty()) {
            if (source != this) {
                this.sendEvent(new DropEvent(source, this, dropped));
            } else {
                this.sendEvent(new MoveEvent(this, dropped, trigger));
            }
        }
    }

    @Nullable
    private class_8016 handleArrowNavigation(class_8023.class_8024 arrowNavigation) {
        Entry entry;
        switch (arrowNavigation.comp_1191()) {
            case field_41826: {
                Entry entry2 = (Entry)this.getPreviousEntry();
                break;
            }
            case field_41827: {
                Entry entry2 = (Entry)this.getNextEntry();
                break;
            }
            default: {
                Entry entry2 = entry = null;
            }
        }
        if (entry != null) {
            if (InputUtil.isRangeModifierActive()) {
                this.selectRange(entry.pack);
            } else {
                this.selectExclusive(entry.pack);
            }
            this.sendEvent(new SelectionEvent(this));
            this.method_25328((class_350.class_351)entry);
            return class_8016.method_48194((class_364)entry, (class_4069[])new class_4069[]{this});
        }
        this.method_25395(null);
        return null;
    }

    @Nullable
    public class_8016 method_48205(class_8023 event) {
        if (!this.method_25370()) {
            class_3288 lastSelected = this.getLastSelected();
            PackList.Entry entry = null;
            if (lastSelected != null) {
                entry = this.getEntry(lastSelected);
            } else if (!this.method_25396().isEmpty()) {
                entry = (Entry)this.method_48200();
            }
            if (entry != null) {
                this.select(((Entry)entry).pack);
                this.method_25328((class_350.class_351)entry);
                return class_8016.method_48194((class_364)entry, (class_4069[])new class_4069[]{this});
            }
        } else {
            if (event instanceof class_8023.class_8024) {
                class_8023.class_8024 arrowNavigation = (class_8023.class_8024)event;
                return this.handleArrowNavigation(arrowNavigation);
            }
            this.method_25395(null);
        }
        return null;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (InputUtil.isTransfer(keyCode, modifiers)) {
            PackList.Entry entry = this.getEntry(this.getLastSelected());
            if (entry != null && ((Entry)entry).transfer()) {
                GuiUtil.playClickSound();
            }
            return entry != null;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    public void replaceState(@NotNull PackList.Snapshot snapshot) {
        this.packs.clear();
        for (class_3288 pack : snapshot.packs()) {
            if (pack == null || this.packs.contains(pack)) continue;
            this.packs.add(pack);
        }
        this.query.update(snapshot.query());
        this.queryPacks();
        this.clearSelection();
        for (class_3288 selected : snapshot.selection()) {
            this.select(selected);
        }
        this.scrollToLastSelected();
    }

    public abstract class Entry
    extends AbstractDynamicList.Entry
    implements PackList.Entry {
        private static final double DRAG_THRESHOLD = 1.0;
        private static final int DOUBLE_CLICK_DELTA_MS = 200;
        protected static final int SPACING = 2;
        protected static final int BACKGROUND_OFFSET = 1;
        protected static final ColoredRect OVERLAY = new ColoredRect(Theme.WHITE.withAlpha(0.25f));
        protected static final ColoredRect SELECTED_OVERLAY = new ColoredRect(Theme.BLUE_500.withAlpha(0.25f));
        protected final List<class_364> children;
        protected final List<class_6379> narratables;
        protected final class_3288 pack;
        private final PackWidget packWidget;
        private long lastClickTime;
        private MouseSelectionState mouseSelectionState;

        protected Entry(class_3288 pack, int index) {
            super(index);
            this.children = new ArrayList<class_364>();
            this.narratables = new ArrayList<class_6379>();
            this.lastClickTime = 0L;
            this.mouseSelectionState = MouseSelectionState.INACTIVE;
            this.pack = pack;
            this.packWidget = new PackWidget(this.pack, PackListBase.this.iconCache, this.method_46426(), PackListBase.this.method_25337(this.index), this.method_25368(), PackListBase.this.field_22741, 2);
            this.children.add((class_364)this.packWidget);
            this.narratables.add((class_6379)this.packWidget);
        }

        @Override
        public class_3288 getPack() {
            return this.pack;
        }

        public boolean isSelected() {
            return PackListBase.this.selection.contains(this.pack);
        }

        public boolean isSelectedLast() {
            return PackListBase.this.getLastSelected() == this.pack;
        }

        private boolean sendSelection() {
            ArrayList<class_3288> payload = new ArrayList<class_3288>();
            for (class_3288 selected : PackListBase.this.getOrderedSelection().reversed()) {
                if (!PackListBase.this.isTransferable(selected)) continue;
                payload.add(selected);
            }
            if (!payload.isEmpty()) {
                class_3288 trigger = this.isTransferable() ? this.pack : null;
                PackListBase.this.sendEvent(new RequestTransferEvent(PackListBase.this, payload, trigger));
                return true;
            }
            return false;
        }

        public boolean transfer() {
            if (!this.isSelected() && this.isTransferable()) {
                PackListBase.this.sendEvent(new RequestTransferEvent(PackListBase.this, this.pack));
                return true;
            }
            return this.sendSelection();
        }

        private boolean handleDoubleClick() {
            long currentTime = class_156.method_658();
            if (this.isTransferable() && this.isSelectedLast() && currentTime - this.lastClickTime <= 200L) {
                PackListBase.this.sendEvent(new RequestTransferEvent(PackListBase.this, this.pack));
                return true;
            }
            this.lastClickTime = currentTime;
            return false;
        }

        private void fireClickEvent(BiConsumer<PackListBase<T>, class_3288> selector, MouseSelectionState state) {
            this.mouseSelectionState = state;
            selector.accept(PackListBase.this, this.pack);
            PackListBase.this.sendEvent(new SelectionEvent(PackListBase.this));
        }

        private boolean exceedsDragThreshold(double dragX, double dragY) {
            return Math.hypot(dragX, dragY) > 1.0;
        }

        public boolean method_25405(double mouseX, double mouseY) {
            return GuiUtil.containsPoint(this.method_46426(), this.method_46427() - 1, this.method_25368(), this.method_25364() + 2, mouseX, mouseY);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (InputUtil.isLeftClick(button) && this.method_25405(mouseX, mouseY)) {
                if (!InputUtil.isRangeModifierActive() && !InputUtil.isSelectModifierActive() && this.handleDoubleClick()) {
                    return true;
                }
                if (InputUtil.isRangeModifierActive()) {
                    this.fireClickEvent(PackListBase::selectRange, MouseSelectionState.SELECTING_MANY);
                } else if (InputUtil.isSelectModifierActive()) {
                    this.fireClickEvent(PackListBase::selectToggle, MouseSelectionState.SELECTING_MANY);
                } else if (!this.isSelected()) {
                    this.fireClickEvent(PackListBase::selectExclusive, MouseSelectionState.SELECTING_ONE);
                } else if (this.isSelected() && !this.isSelectedLast()) {
                    this.fireClickEvent(PackListBase::select, MouseSelectionState.SELECTING_ONE);
                } else {
                    this.mouseSelectionState = MouseSelectionState.SELECTING_ONE;
                }
                return true;
            }
            this.mouseSelectionState = MouseSelectionState.INACTIVE;
            return false;
        }

        public boolean method_25406(double mouseX, double mouseY, int button) {
            if (this.isSelectedLast() && this.method_25405(mouseX, mouseY) && this.mouseSelectionState == MouseSelectionState.SELECTING_ONE && PackListBase.this.selection.size() > 1) {
                this.fireClickEvent(PackListBase::selectExclusive, MouseSelectionState.INACTIVE);
                return true;
            }
            this.mouseSelectionState = MouseSelectionState.INACTIVE;
            return false;
        }

        public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
            if (!this.method_25405(mouseX, mouseY)) {
                this.mouseSelectionState = MouseSelectionState.INACTIVE;
                return false;
            }
            if (this.isSelected() && !this.pack.method_14465() && this.mouseSelectionState == MouseSelectionState.SELECTING_ONE && this.exceedsDragThreshold(dragX, dragY)) {
                PackListBase.this.sendEvent(new DragEvent(PackListBase.this, PackListBase.this.getOrderedSelection().reversed(), this.pack, this.packWidget.getSprite()));
                return true;
            }
            return false;
        }

        public void method_49568(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
            if (!this.pack.method_14460().method_14437()) {
                int backgroundTop = this.method_46427() - 1;
                int backgroundLeft = this.method_46426() + 1;
                int backgroundBottom = backgroundTop + this.method_25364() + 2;
                int backgroundRight = backgroundLeft + this.method_25368() - 2;
                guiGraphics.method_25294(backgroundLeft, backgroundTop, backgroundRight, backgroundBottom, Theme.RED_900.getARGB());
            }
        }

        protected abstract void renderForeground(class_332 var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8, float var9);

        private void renderSelection(class_332 guiGraphics, int top, int left, int width, int height) {
            if (this.isSelected()) {
                int overlayTop = this.method_46427() - 1;
                int overlayLeft = this.method_46426() + 1;
                int overlayWidth = this.method_25368() - 2;
                int overlayHeight = this.method_25364() + 2;
                ObjectsUtil.pick(this.isSelectedLast(), OVERLAY, SELECTED_OVERLAY).render(guiGraphics, overlayLeft, overlayTop, overlayWidth, overlayHeight);
            }
            if (this.isSelected() || this.method_25370()) {
                int outlineTop = top - 2;
                int outlineHeight = height + 4;
                if (this.method_25370()) {
                    class_4587 poseStack = guiGraphics.method_51448();
                    poseStack.method_22903();
                    poseStack.method_46416(0.0f, 0.0f, 1.0f);
                    guiGraphics.method_49601(left, outlineTop, width, outlineHeight, Theme.WHITE.getARGB());
                    poseStack.method_22909();
                } else {
                    guiGraphics.method_49601(left, outlineTop, width, outlineHeight, Theme.BLUE_500.getARGB());
                }
            }
        }

        private void renderWidget(class_332 guiGraphics, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            this.packWidget.method_48229(left, top);
            this.packWidget.method_25358(width);
            this.packWidget.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            this.renderSelection(guiGraphics, top, left, width, height);
            this.renderForeground(guiGraphics, top, left, width, height, mouseX, mouseY, hovering, partialTick);
        }

        public final void method_25343(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            this.renderWidget(guiGraphics, top, left, width, height, mouseX, mouseY, hovering, partialTick);
        }

        @NotNull
        public List<? extends class_364> method_25396() {
            return this.children;
        }

        @NotNull
        public List<? extends class_6379> method_37025() {
            return this.narratables;
        }

        private static enum MouseSelectionState {
            INACTIVE,
            SELECTING_ONE,
            SELECTING_MANY;

        }
    }
}

