/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.gui.components.pack;

import io.github.fishstiz.fidgetz.gui.components.CyclicButton;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.ButtonSprites;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.Sprite;
import io.github.fishstiz.fidgetz.gui.shapes.Size;
import io.github.fishstiz.packed_packs.util.ResourceUtil;
import io.github.fishstiz.packed_packs.util.pack.PackUtil;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_3288;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Query {
    private boolean hideIncompatible = false;
    private SortOption sort;
    private String search;

    Query() {
    }

    Query(boolean hideIncompatible, SortOption sort, String search) {
        this.hideIncompatible = hideIncompatible;
        this.sort = sort;
        this.search = search;
    }

    boolean setHideIncompatible(boolean hideIncompatible) {
        boolean updated = this.hideIncompatible != hideIncompatible;
        this.hideIncompatible = hideIncompatible;
        return updated;
    }

    boolean setSort(SortOption sort) {
        boolean updated = !Objects.equals(this.sort, sort);
        this.sort = sort;
        return updated;
    }

    boolean setSearch(String search) {
        boolean updated = !Objects.equals(this.search, search);
        this.search = search;
        return updated;
    }

    boolean update(boolean incompatibleHidden, SortOption sort, String search) {
        boolean updated = this.setHideIncompatible(incompatibleHidden);
        updated |= this.setSort(sort);
        return updated |= this.setSearch(search);
    }

    boolean update(Query query) {
        return this.update(query.hideIncompatible, query.sort, query.search);
    }

    void apply(List<class_3288> packs) {
        Objects.requireNonNull(packs);
        if (this.hideIncompatible) {
            packs.removeIf(pack -> !pack.method_14460().method_14437());
        }
        if (this.search != null && !this.search.isEmpty()) {
            packs.removeIf(pack -> !pack.method_14457().getString().toLowerCase().contains(this.search.toLowerCase()));
        }
        if (this.sort != null) {
            packs.sort(this.sort.getComparator());
        }
    }

    boolean isQuerying() {
        return this.hideIncompatible || this.search != null && !this.search.isEmpty() || this.sort != null;
    }

    public Query copy() {
        return new Query(this.hideIncompatible, this.sort, this.search);
    }

    public boolean isHideIncompatible() {
        return this.hideIncompatible;
    }

    public SortOption getSort() {
        return this.sort;
    }

    public String getSearch() {
        return this.search;
    }

    public static enum SortOption implements CyclicButton.SpriteOption
    {
        A_Z("sort.a_z", "sort_a_z", Comparator.comparing(pack -> pack.method_14457().getString())),
        Z_A("sort.z_a", "sort_z_a", A_Z.getComparator().reversed()),
        RECENT("sort.recent", "sort_recent", Comparator.comparingLong(PackUtil::getLastUpdatedEpochMs).reversed()),
        OLDEST("sort.oldest", "sort_oldest", Comparator.comparingLong(PackUtil::getLastUpdatedEpochMs));

        private final class_2561 component;
        private final class_7919 tooltip;
        private final ButtonSprites sprites;
        private final Comparator<class_3288> comparator;

        private SortOption(String key, String icon, Comparator<class_3288> comparator) {
            this.component = ResourceUtil.getText(key, new Object[0]);
            this.tooltip = class_7919.method_47407((class_2561)this.component);
            this.sprites = ButtonSprites.of(new Sprite(ResourceUtil.getIcon(icon), Size.of16()));
            this.comparator = comparator;
        }

        @Override
        @NotNull
        public class_2561 text() {
            return this.component;
        }

        @NotNull
        public Comparator<class_3288> getComparator() {
            return this.comparator;
        }

        @Override
        @Nullable
        public class_7919 tooltip() {
            return this.tooltip;
        }

        @Override
        @Nullable
        public ButtonSprites sprites() {
            return this.sprites;
        }
    }
}

