/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.gui.components.profile;

import io.github.fishstiz.fidgetz.gui.components.AbstractDynamicList;
import io.github.fishstiz.fidgetz.gui.components.FidgetzButton;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.Sprite;
import io.github.fishstiz.fidgetz.gui.shapes.Size;
import io.github.fishstiz.fidgetz.util.debounce.PollingDebouncer;
import io.github.fishstiz.packed_packs.config.Config;
import io.github.fishstiz.packed_packs.config.Profile;
import io.github.fishstiz.packed_packs.util.ResourceUtil;
import io.github.fishstiz.packed_packs.util.constants.Theme;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_6379;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;

public class ProfileList
extends AbstractDynamicList<Entry> {
    private static final int ITEM_HEIGHT = 20;
    private static final class_2561 EMPTY_TEXT = ResourceUtil.getText("profile.empty", new Object[0]);
    private static final class_2561 DELETE_TEXT = ResourceUtil.getText("profile.delete", new Object[0]);
    private static final class_7919 DELETE_INFO = class_7919.method_47407((class_2561)ResourceUtil.getText("profile.delete.info", new Object[0]));
    private static final Sprite TRASH_SPRITE = new Sprite(ResourceUtil.getIcon("trash"), Size.of16());
    private final PollingDebouncer<Void> debouncedRefresh = new PollingDebouncer(this::refresh, 200L);
    private final Config.Packs config;
    private final Supplier<Profile> selected;
    private final Consumer<Profile> onDelete;
    private final Consumer<Profile> onSelect;
    private List<Profile> profiles;

    public ProfileList(Config.Packs config, Supplier<Profile> selected, Consumer<Profile> onDelete, Consumer<Profile> onSelect) {
        super(20, 6, 0, 0);
        this.config = config;
        this.selected = selected;
        this.onDelete = onDelete;
        this.onSelect = onSelect;
        this.refresh();
    }

    public void scheduleRefresh() {
        this.debouncedRefresh.run();
    }

    public void refresh() {
        this.method_25339();
        this.profiles = this.config.getProfiles();
        for (int i = 0; i < this.profiles.size(); ++i) {
            this.method_25321((class_350.class_351)new Entry(this.profiles.get(i), i));
        }
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.debouncedRefresh.poll();
        super.method_48579(guiGraphics, mouseX, mouseY, partialTick);
        if (this.profiles == null || this.profiles.isEmpty()) {
            int padding = 8;
            ProfileList.method_52718((class_332)guiGraphics, (class_327)this.field_22740.field_1772, (class_2561)EMPTY_TEXT, (int)(this.method_46426() + padding), (int)(this.method_46427() + padding), (int)(this.method_55442() - padding), (int)(this.method_55443() - padding), (int)Theme.WHITE.getARGB());
        }
    }

    public class Entry
    extends AbstractDynamicList.Entry {
        private final Profile profile;
        private final List<FidgetzButton<Void>> children;
        private final FidgetzButton<Void> selectButton;
        private final FidgetzButton<Void> deleteButton;

        protected Entry(Profile profile, int index) {
            super(index);
            this.children = new ArrayList<FidgetzButton<Void>>();
            this.profile = profile;
            this.deleteButton = ((FidgetzButton.Builder)((FidgetzButton.Builder)((FidgetzButton.Builder)((FidgetzButton.Builder)((FidgetzButton.Builder)FidgetzButton.builder().makeSquare(this.method_25364())).setMessage(DELETE_TEXT)).setTooltip(DELETE_INFO)).setSpriteOnly(TRASH_SPRITE)).setOnPress(() -> ProfileList.this.onDelete.accept(this.profile))).build();
            this.selectButton = ((FidgetzButton.Builder)((FidgetzButton.Builder)FidgetzButton.builder().setMessage((class_2561)class_2561.method_43470((String)this.profile.getName()))).setOnPress(() -> ProfileList.this.onSelect.accept(this.profile))).build();
            this.children.add(this.deleteButton);
            this.children.add(this.selectButton);
        }

        public void method_25343(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            this.selectButton.field_22763 = ProfileList.this.selected.get() != this.profile;
            this.deleteButton.method_48229(left, top);
            this.selectButton.method_48229(left + this.deleteButton.method_25368(), top);
            this.selectButton.method_25358(width - this.deleteButton.method_25368());
            this.deleteButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            this.selectButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }

        @NotNull
        public List<? extends class_364> method_25396() {
            return this.children;
        }

        @NotNull
        public List<? extends class_6379> method_37025() {
            return this.children;
        }

        @Override
        public void method_48206(Consumer<class_339> consumer) {
            this.children.forEach(consumer);
        }
    }
}

