/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.gui.screens;

import io.github.fishstiz.packed_packs.gui.components.events.DragEvent;
import io.github.fishstiz.packed_packs.gui.components.events.DragEventHandler;
import io.github.fishstiz.packed_packs.gui.components.events.DropEvent;
import io.github.fishstiz.packed_packs.gui.components.events.MoveEvent;
import io.github.fishstiz.packed_packs.gui.components.events.PackListEvent;
import io.github.fishstiz.packed_packs.gui.components.events.PackListEventListener;
import io.github.fishstiz.packed_packs.gui.components.events.RequestTransferEvent;
import io.github.fishstiz.packed_packs.gui.components.events.SelectionEvent;
import io.github.fishstiz.packed_packs.gui.components.pack.PackList;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_3288;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_8016;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PackListEventHandler
extends class_437
implements PackListEventListener,
DragEventHandler {
    private DragEvent dragged;

    protected PackListEventHandler(class_2561 title) {
        super(title);
    }

    protected void focus(class_8016 path) {
        this.method_48267();
        path.method_48195(true);
    }

    protected void focus(class_364 element) {
        this.focus(class_8016.method_48194((class_364)element, (class_4069[])new class_4069[]{this}));
    }

    protected void focusList(PackList packList) {
        PackList.Entry entry = packList.getSelected();
        if (entry != null) {
            this.focus(class_8016.method_48194((class_364)entry, (class_4069[])new class_4069[]{packList, this}));
        } else {
            this.focus(class_8016.method_48194((class_364)packList, (class_4069[])new class_4069[]{this}));
        }
    }

    protected void transferFocus(PackList source, PackList destination) {
        source.method_25395(null);
        this.focusList(destination);
    }

    protected void unfocusOtherLists(PackList focused) {
        for (PackList packList : this.getPackLists()) {
            if (packList == focused) continue;
            packList.method_25395(null);
        }
    }

    private void handleRequestTransferEvent(RequestTransferEvent event) {
        PackList source = event.target();
        PackList destination = this.getDestination(source);
        if (event.payload().isEmpty()) {
            return;
        }
        destination.clearSelection();
        source.removeAll((List<class_3288>)event.payload());
        destination.addAll((List<class_3288>)event.payload());
        destination.selectAll((List<class_3288>)event.payload());
        destination.select(event.trigger());
        this.transferFocus(source, destination);
    }

    @Override
    public void handleDragEvent(DragEvent event) {
        DragEventHandler.super.handleDragEvent(event);
        this.unfocusOtherLists(event.target());
    }

    private void handleMoveEvent(MoveEvent event) {
        PackList.Entry entry = event.target().getEntry(event.trigger());
        if (entry != null) {
            this.focus(class_8016.method_48194((class_364)entry, (class_4069[])new class_4069[]{event.target(), this}));
        } else {
            this.focus((class_364)event.target());
        }
    }

    @Override
    @Nullable
    public DragEvent getDragged() {
        return this.dragged;
    }

    @Override
    public void setDragged(@Nullable DragEvent dragged) {
        this.dragged = dragged;
    }

    @NotNull
    protected abstract List<PackList> getPackLists();

    @NotNull
    protected abstract PackList getDestination(PackList var1);

    @Override
    public void onEvent(PackListEvent event) {
        PackListEvent packListEvent = event;
        Objects.requireNonNull(packListEvent);
        PackListEvent packListEvent2 = packListEvent;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SelectionEvent.class, RequestTransferEvent.class, MoveEvent.class, DragEvent.class, DropEvent.class}, (Object)packListEvent2, n)) {
            case 0: {
                SelectionEvent selection = (SelectionEvent)packListEvent2;
                this.unfocusOtherLists(selection.target());
                break;
            }
            case 1: {
                RequestTransferEvent request = (RequestTransferEvent)packListEvent2;
                this.handleRequestTransferEvent(request);
                break;
            }
            case 2: {
                MoveEvent move = (MoveEvent)packListEvent2;
                this.handleMoveEvent(move);
                break;
            }
            case 3: {
                DragEvent drag = (DragEvent)packListEvent2;
                this.handleDragEvent(drag);
                break;
            }
            case 4: {
                DropEvent drop = (DropEvent)packListEvent2;
                this.transferFocus(drop.target(), drop.destination());
                break;
            }
        }
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        DragEvent event = this.getDragged();
        if (event != null) {
            class_4587 poseStack = guiGraphics.method_51448();
            poseStack.method_22903();
            poseStack.method_46416(0.0f, 0.0f, this.getDroppableZ());
            for (PackList list : this.getPackLists()) {
                list.renderDroppableZone(guiGraphics, event.target(), event.payload(), event.trigger(), mouseX, mouseY, partialTick);
            }
            poseStack.method_46416(0.0f, 0.0f, 1.0f);
            event.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            poseStack.method_22909();
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        return this.isDraggingSelection() || super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char codePoint, int modifiers) {
        return this.isDraggingSelection() || super.method_25400(codePoint, modifiers);
    }
}

