/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.gui.screens;

import com.google.common.collect.ImmutableList;
import io.github.fishstiz.fidgetz.gui.components.FidgetzButton;
import io.github.fishstiz.fidgetz.gui.components.LayoutWrapper;
import io.github.fishstiz.fidgetz.gui.components.Modal;
import io.github.fishstiz.fidgetz.gui.components.ToggleableDialog;
import io.github.fishstiz.fidgetz.gui.components.ToggleableDialogContainer;
import io.github.fishstiz.fidgetz.gui.components.ToggleableEditBox;
import io.github.fishstiz.fidgetz.gui.layouts.FlexLayout;
import io.github.fishstiz.fidgetz.gui.renderables.ColoredRect;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.Sprite;
import io.github.fishstiz.fidgetz.gui.shapes.Size;
import io.github.fishstiz.fidgetz.util.debounce.ImmediateDebouncer;
import io.github.fishstiz.fidgetz.util.debounce.PollingDebouncer;
import io.github.fishstiz.packed_packs.PackedPacks;
import io.github.fishstiz.packed_packs.compat.ModAdditions;
import io.github.fishstiz.packed_packs.config.Config;
import io.github.fishstiz.packed_packs.config.Profile;
import io.github.fishstiz.packed_packs.gui.components.events.PackListEvent;
import io.github.fishstiz.packed_packs.gui.components.pack.AvailablePackList;
import io.github.fishstiz.packed_packs.gui.components.pack.CurrentPackList;
import io.github.fishstiz.packed_packs.gui.components.pack.PackList;
import io.github.fishstiz.packed_packs.gui.components.profile.Sidebar;
import io.github.fishstiz.packed_packs.gui.history.HistoryManager;
import io.github.fishstiz.packed_packs.gui.history.Restorable;
import io.github.fishstiz.packed_packs.gui.layouts.OptionsLayout;
import io.github.fishstiz.packed_packs.gui.layouts.ProfilesLayout;
import io.github.fishstiz.packed_packs.gui.layouts.pack.AvailablePacksLayout;
import io.github.fishstiz.packed_packs.gui.layouts.pack.CurrentPacksLayout;
import io.github.fishstiz.packed_packs.gui.layouts.pack.PackLayout;
import io.github.fishstiz.packed_packs.gui.metadata.PackSelectionScreenArgs;
import io.github.fishstiz.packed_packs.gui.screens.PackListEventHandler;
import io.github.fishstiz.packed_packs.transform.interfaces.IPackSelectionModel;
import io.github.fishstiz.packed_packs.transform.interfaces.IPackSelectionScreen;
import io.github.fishstiz.packed_packs.transform.mixin.HeaderAndFooterLayoutAccess;
import io.github.fishstiz.packed_packs.transform.mixin.PackSelectionScreenAccessor;
import io.github.fishstiz.packed_packs.util.InputUtil;
import io.github.fishstiz.packed_packs.util.ResourceUtil;
import io.github.fishstiz.packed_packs.util.constants.Theme;
import io.github.fishstiz.packed_packs.util.lang.ObjectsUtil;
import io.github.fishstiz.packed_packs.util.pack.PackRepositoryHelper;
import io.github.fishstiz.packed_packs.util.pack.PackUtil;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3288;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_403;
import net.minecraft.class_410;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5375;
import net.minecraft.class_7847;
import net.minecraft.class_7919;
import net.minecraft.class_8021;
import net.minecraft.class_8132;
import net.minecraft.class_8667;
import net.minecraft.class_8669;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackedPacksScreen
extends PackListEventHandler
implements ToggleableDialogContainer,
Restorable<Snapshot> {
    private static final class_2561 ACTION_BAR_INFO = ResourceUtil.getText("toggle_actionbar.info", new Object[0]);
    private static final class_2561 ORIGINAL_SCREEN_INFO = ResourceUtil.getText("original_screen.info", new Object[0]);
    private static final class_2561 OPTIONS_TEXT = ResourceUtil.getText("options.title", new Object[0]);
    private static final class_2561 OPEN_FOLDER_TEXT = class_2561.method_43471((String)"pack.openFolder");
    private static final class_2561 OPEN_FOLDER_INFO_TEXT = class_2561.method_43471((String)"pack.folderInfo");
    private static final class_2561 APPLY_TEXT = ResourceUtil.getText("apply", new Object[0]);
    private static final int SPACING = 8;
    private static final float SIDEBAR_Z = 100.0f;
    private static final float DROP_ZONE_Z = 200.0f;
    private static final float OPTIONS_Z = 300.0f;
    private final class_437 previous;
    private final PackSelectionScreenArgs original;
    private final PackRepositoryHelper repository;
    private final class_8132 layout = new class_8132((class_437)this);
    private final HistoryManager<Snapshot> history = new HistoryManager();
    private final AvailablePacksLayout availablePacks;
    private final CurrentPacksLayout currentPacks;
    private final Config.Packs packsConfig;
    private final ProfilesLayout profiles;
    private final ImmediateDebouncer<String> searchListener = new ImmediateDebouncer(this::clearHistory, 250L);
    private final PollingDebouncer<Void> revalidateTask = new PollingDebouncer(this::revalidate, 1000L);
    private final Modal<class_8667> options = ((Modal.Builder)((Modal.Builder)((Modal.Builder)Modal.builder(this, new OptionsLayout(8).layout()).setBackdrop(new ColoredRect(Theme.BLACK.withAlpha(0.5f)))).setCaptureFocus(true)).setZ(300.0f)).build();
    private class_5375.class_5426 watcher;
    private boolean showActionBar = PackedPacks.CONFIG.isShowActionBar();
    private boolean initialized = false;

    public PackedPacksScreen(class_437 previous, PackSelectionScreenArgs original) {
        super((class_2561)ResourceUtil.getModName());
        this.previous = previous;
        this.original = original;
        this.repository = new PackRepositoryHelper(this.original.repository(), this.original.packDir());
        this.availablePacks = new AvailablePacksLayout(this.repository, this, 8);
        this.currentPacks = new CurrentPacksLayout(this.repository, this, 8);
        this.packsConfig = this.original.isResourcePackDir() ? PackedPacks.CONFIG.getResourcepacks() : PackedPacks.CONFIG.getDatapacks();
        this.profiles = new ProfilesLayout(((Sidebar.Builder)Sidebar.builder(this).setZ(100.0f)).setHeaderSettings(class_7847.method_46481().method_46469(8).method_46471(7)), this.packsConfig, ((CurrentPackList)this.currentPacks.getList())::copyPacks, this::onProfileChange);
        this.watcher = class_5375.class_5426.method_30293((Path)this.original.packDir());
    }

    public void method_49589() {
        if (this.initialized) {
            this.revalidateTask.run();
        }
    }

    protected void method_25426() {
        this.layout.method_48992((class_8021)this.createHeader());
        this.layout.method_48999((class_8021)this.createContents());
        this.layout.method_48996((class_8021)this.createFooter());
        this.profiles.initContents(8);
        this.profiles.getSidebar().getCloseButton().addListener(() -> this.method_56131());
        ((LayoutWrapper)((Object)this.options.root())).method_48206(this.options::addRenderableWidget);
        this.method_25429((class_364)this.options);
        this.method_25429((class_364)this.profiles.getSidebar());
        this.layout.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.method_37060(this.profiles.getSidebar());
        this.method_37060(this.options);
        this.clearHistory();
        this.method_48640();
        this.initialized = true;
    }

    private FlexLayout createHeader() {
        FlexLayout header = FlexLayout.horizontal(this::getMaxWidth).spacing(8);
        header.addChild(((FidgetzButton.Builder)((FidgetzButton.Builder)((FidgetzButton.Builder)((FidgetzButton.Builder)((FidgetzButton.Builder)FidgetzButton.builder().makeSquare()).setMessage(ProfilesLayout.TITLE_TEXT)).setTooltip(class_7919.method_47407((class_2561)ProfilesLayout.TITLE_TEXT))).setSpriteOnly(new Sprite(ResourceUtil.getIcon("hamburger"), Size.of16()))).setOnPress(this.profiles.getSidebar()::toggle)).build());
        header.addChild(((FidgetzButton.Builder)((FidgetzButton.Builder)((FidgetzButton.Builder)((FidgetzButton.Builder)FidgetzButton.builder().makeSquare()).setTooltip(class_7919.method_47407((class_2561)ACTION_BAR_INFO))).setSpriteOnly(new Sprite(ResourceUtil.getIcon("filter"), Size.of16()))).setOnPress(this::toggleActionBar)).build());
        header.addChild(this.profiles.getToggleNameButton());
        header.addFlexChild(this.profiles.getNameField());
        ModAdditions.appendHeader((class_437)this.original.createScreen(), this.original.title(), header);
        header.addChild(((FidgetzButton.Builder)((FidgetzButton.Builder)((FidgetzButton.Builder)((FidgetzButton.Builder)((FidgetzButton.Builder)FidgetzButton.builder().makeSquare()).setMessage(OPTIONS_TEXT)).setTooltip(class_7919.method_47407((class_2561)OPTIONS_TEXT))).setSpriteOnly(new Sprite(ResourceUtil.getIcon("gear"), Size.of16()))).setOnPress(this.options::toggle)).build());
        header.addChild(((FidgetzButton.Builder)((FidgetzButton.Builder)((FidgetzButton.Builder)((FidgetzButton.Builder)FidgetzButton.builder().makeSquare()).setTooltip(class_7919.method_47407((class_2561)ORIGINAL_SCREEN_INFO))).setSpriteOnly(new Sprite(ResourceUtil.getIcon("exit"), Size.of16()))).setOnPress(this::setOriginalScreen)).build());
        return header;
    }

    private FlexLayout createContents() {
        FlexLayout contents = FlexLayout.horizontal(this::getMaxWidth).spacing(8);
        this.availablePacks.init(contents.addFlexChild(FlexLayout.vertical(() -> ((class_8132)this.layout).method_57727()).spacing(8), false));
        this.currentPacks.init(contents.addFlexChild(FlexLayout.vertical(() -> ((class_8132)this.layout).method_57727()).spacing(8), false));
        this.currentPacks.getSearchField().addListener(this.searchListener);
        this.availablePacks.getSearchField().addListener(this.searchListener);
        return contents;
    }

    private FlexLayout createFooter() {
        FlexLayout footer = FlexLayout.horizontal(this::getMaxWidth).spacing(8);
        FlexLayout firstColumn = FlexLayout.horizontal().spacing(8);
        FlexLayout secondColumn = firstColumn.copyLayout();
        firstColumn.addFlexChild(((FidgetzButton.Builder)((FidgetzButton.Builder)((FidgetzButton.Builder)FidgetzButton.builder().setMessage(OPEN_FOLDER_TEXT)).setTooltip(class_7919.method_47407((class_2561)OPEN_FOLDER_INFO_TEXT))).setOnPress(this.repository::openDirectory)).build());
        if (this.original.isResourcePackDir()) {
            secondColumn.addFlexChild(((FidgetzButton.Builder)((FidgetzButton.Builder)FidgetzButton.builder().setMessage(APPLY_TEXT)).setOnPress(this::commit)).build());
        }
        secondColumn.addFlexChild(((FidgetzButton.Builder)((FidgetzButton.Builder)FidgetzButton.builder().setMessage(class_5244.field_24334)).setOnPress(this::method_25419)).build());
        footer.addFlexChild(firstColumn);
        footer.addFlexChild(secondColumn);
        return footer;
    }

    public int getMaxWidth() {
        return this.field_22789 - 16;
    }

    public void method_25393() {
        if (this.watcher != null) {
            try {
                if (this.watcher.method_30292()) {
                    this.revalidateTask.run();
                }
            }
            catch (IOException e) {
                PackedPacks.LOGGER.warn("Failed to poll for directory {} changes, stopping", (Object)this.original.packDir(), (Object)e);
                this.closeWatcher();
            }
        }
        this.revalidateTask.poll();
    }

    public void method_29638(List<Path> packs) {
        if (this.field_22787 != null) {
            String packNames = PackUtil.extractPackNames(packs).collect(Collectors.joining(", "));
            this.field_22787.method_1507((class_437)new class_410(this.confirmFileDrop(packs), (class_2561)class_2561.method_43471((String)"pack.dropConfirm"), (class_2561)class_2561.method_43470((String)packNames)));
        }
    }

    private BooleanConsumer confirmFileDrop(List<Path> packs) {
        return confirmed -> {
            if (this.field_22787 == null) {
                return;
            }
            if (!confirmed) {
                this.field_22787.method_1507((class_437)this);
                return;
            }
            PackUtil.PackValidation results = PackUtil.validatePaths(packs, PackUtil.createPackDetector());
            if (!results.symlinkWarnings().isEmpty()) {
                this.field_22787.method_1507(class_8669.method_52750(() -> this.field_22787.method_1507((class_437)this)));
                return;
            }
            if (!results.valid().isEmpty()) {
                class_5375.method_29669((class_310)this.field_22787, results.valid(), (Path)this.original.packDir());
                this.revalidate();
            }
            if (!results.rejected().isEmpty()) {
                String rejectedNames = PackUtil.extractPackNames(results.rejected()).collect(Collectors.joining(", "));
                this.field_22787.method_1507((class_437)new class_403(() -> this.field_22787.method_1507((class_437)this), (class_2561)class_2561.method_43471((String)"pack.dropRejected.title"), (class_2561)class_2561.method_43469((String)"pack.dropRejected.message", (Object[])new Object[]{rejectedNames})));
                return;
            }
            this.field_22787.method_1507((class_437)this);
        };
    }

    private void setOriginalScreen() {
        if (this.previous instanceof class_5375) {
            this.method_25419();
        } else if (this.field_22787 != null) {
            class_5375 originalScreen = this.original.createScreen();
            ((IPackSelectionScreen)originalScreen).packedPacks$setPrevious(this.previous);
            this.field_22787.method_1507((class_437)originalScreen);
        }
    }

    public void method_25419() {
        Config.ResourcePacks resourcePacks;
        if (this.field_22787 == null) {
            return;
        }
        Config.Packs packs = this.packsConfig;
        if (!(packs instanceof Config.ResourcePacks) || (resourcePacks = (Config.ResourcePacks)packs).isApplyOnClose()) {
            this.commit();
        }
        if (!this.original.isResourcePackDir() && !(this.previous instanceof class_5375)) {
            this.original.output().accept(this.repository.getRepository());
            return;
        }
        packs = this.previous;
        if (packs instanceof PackSelectionScreenAccessor) {
            PackSelectionScreenAccessor packScreen = (PackSelectionScreenAccessor)((Object)packs);
            ((IPackSelectionModel)packScreen.getModel()).packed_packs$reset();
            packScreen.invokeReload();
        }
        this.field_22787.method_1507(this.previous);
    }

    public void method_25432() {
        this.closeWatcher();
        this.updateProfile(this.profiles.getProfile());
        this.packsConfig.setLastViewed(this.profiles.getProfile());
        PackedPacks.CONFIG.save();
    }

    private void closeWatcher() {
        if (this.watcher != null) {
            try {
                this.watcher.close();
                this.watcher = null;
            }
            catch (Exception e) {
                PackedPacks.LOGGER.error("Failed to close watcher for pack directory '{}'.", (Object)this.original.packDir(), (Object)e);
            }
        }
    }

    private void repositionLists() {
        this.availablePacks.setHeaderVisibility(this.showActionBar);
        this.currentPacks.setHeaderVisibility(this.showActionBar);
    }

    protected void method_48640() {
        this.layout.method_48222();
        ((HeaderAndFooterLayoutAccess)this.layout).getContentsFrame().method_46419(this.layout.method_48998());
        this.profiles.getSidebar().repositionElements();
        this.options.repositionElements();
        this.repositionLists();
    }

    public void toggleActionBar() {
        this.showActionBar = !this.showActionBar;
        PackedPacks.CONFIG.setShowActionBar(this.showActionBar);
        this.repositionLists();
    }

    public void commit() {
        this.currentPacks.getSearchField().method_1852("");
        this.updateProfile(this.profiles.getProfile());
        this.repository.selectPacks((List<class_3288>)((CurrentPackList)this.currentPacks.getList()).copyPacks());
        if (this.original.isResourcePackDir() && this.field_22787 != null) {
            this.field_22787.field_1690.method_49598(this.repository.getRepository());
        }
    }

    private void replacePacks(PackList list, ImmutableList<class_3288> packs) {
        list.replaceState(new PackList.Snapshot(list, packs, list.copySelection(), list.copyQuery()));
    }

    public void refresh() {
        this.repository.refresh();
    }

    public void revalidate() {
        this.repository.refresh();
        Object availableList = this.availablePacks.getList();
        Object currentList = this.currentPacks.getList();
        PackRepositoryHelper.PackGroup packs = this.repository.validatePacks((List<class_3288>)availableList.copyPacks(), (List<class_3288>)currentList.copyPacks());
        this.replacePacks((PackList)availableList, packs.unselected());
        this.replacePacks((PackList)currentList, packs.selected());
        this.clearHistory();
    }

    public void reset() {
        PackRepositoryHelper.PackGroup packs = this.repository.getPacksByRequirement();
        ((AvailablePackList)this.availablePacks.getList()).reload((Collection<class_3288>)packs.unselected());
        ((CurrentPackList)this.currentPacks.getList()).reload((Collection<class_3288>)packs.selected());
        this.clearHistory();
    }

    public void useSelected() {
        PackRepositoryHelper.PackGroup packs = this.repository.getPacksBySelected();
        ((AvailablePackList)this.availablePacks.getList()).reload((Collection<class_3288>)packs.unselected());
        ((CurrentPackList)this.currentPacks.getList()).reload((Collection<class_3288>)packs.selected());
        this.clearHistory();
    }

    public void onProfileChange(@Nullable Profile profile) {
        if (profile == null) {
            this.useSelected();
        } else if (!profile.getPackIds().isEmpty()) {
            this.applyProfile(profile);
        } else {
            this.reset();
        }
        this.availablePacks.getSearchField().method_1852("");
        this.currentPacks.getSearchField().method_1852("");
    }

    private void applyProfile(@NotNull Profile profile) {
        ImmutableList<class_3288> available = ((AvailablePackList)this.availablePacks.getList()).copyPacks();
        List<class_3288> current = this.repository.getPacksById(profile.getPackIds());
        PackRepositoryHelper.PackGroup packs = this.repository.validatePacks((List<class_3288>)available, current);
        ((AvailablePackList)this.availablePacks.getList()).reload((Collection<class_3288>)packs.unselected());
        ((CurrentPackList)this.currentPacks.getList()).reload((Collection<class_3288>)packs.selected());
        this.clearHistory();
    }

    public void updateProfile(@Nullable Profile profile) {
        if (profile != null) {
            profile.setPacks((List<class_3288>)((CurrentPackList)this.currentPacks.getList()).copyPacks());
        }
    }

    @Override
    @NotNull
    public List<PackList> getPackLists() {
        return List.of(this.availablePacks.getList(), this.currentPacks.getList());
    }

    @Override
    @NotNull
    public PackList getDestination(PackList source) {
        PackList packList = source;
        Objects.requireNonNull(packList);
        PackList packList2 = packList;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AvailablePackList.class, CurrentPackList.class}, (Object)packList2, n)) {
            case 0 -> {
                AvailablePackList ignore = (AvailablePackList)packList2;
                yield (CurrentPackList)this.currentPacks.getList();
            }
            case 1 -> {
                CurrentPackList ignore = (CurrentPackList)packList2;
                yield (AvailablePackList)this.availablePacks.getList();
            }
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(source));
        };
    }

    @Override
    protected void transferFocus(PackList source, PackList destination) {
        super.transferFocus(source, destination);
        if (destination == this.currentPacks.getList()) {
            ((CurrentPackList)this.currentPacks.getList()).scrollToLastSelected();
        }
    }

    @Override
    public void onEvent(PackListEvent event) {
        super.onEvent(event);
        this.profiles.getSidebar().setOpen(false);
        if (event.modifiesTarget()) {
            this.history.push(this.captureState());
        }
    }

    @Override
    public float getDroppableZ() {
        return 200.0f;
    }

    @Nullable
    public PackLayout<?> getLayoutFromSelectedList() {
        return ObjectsUtil.firstNonNull(ObjectsUtil.pick(this.availablePacks, this.currentPacks, pl -> pl.getList() == this.method_25399()), ObjectsUtil.pick(this.availablePacks, this.currentPacks, pl -> pl.getList().method_49606()), ObjectsUtil.pick(this.availablePacks, this.currentPacks, pl -> pl.getList().method_25370()));
    }

    public ToggleableEditBox<Void> focusSearchField(@NotNull PackLayout<?> packLayout) {
        if (!this.showActionBar) {
            this.toggleActionBar();
        }
        ToggleableEditBox<Void> searchField = packLayout.getSearchField();
        this.focus((class_364)searchField);
        return searchField;
    }

    @Override
    public boolean method_25400(char codePoint, int modifiers) {
        PackLayout<?> packLayout;
        if (super.method_25400(codePoint, modifiers)) {
            return true;
        }
        if (codePoint != ' ' && (packLayout = this.getLayoutFromSelectedList()) != null && !packLayout.getSearchField().method_25370()) {
            return this.focusSearchField(packLayout).method_25400(codePoint, modifiers);
        }
        return false;
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        ToggleableEditBox<Void> searchField;
        PackLayout<?> packLayout;
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (InputUtil.isRedo(keyCode, modifiers)) {
            return this.history.redo();
        }
        if (InputUtil.isUndo(keyCode, modifiers)) {
            return this.history.undo();
        }
        if (keyCode == 259 && (packLayout = this.getLayoutFromSelectedList()) != null && !(searchField = packLayout.getSearchField()).method_25370() && !searchField.method_1882().isEmpty()) {
            return this.focusSearchField(packLayout).method_25404(keyCode, scanCode, modifiers);
        }
        return false;
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (ToggleableDialogContainer.super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (InputUtil.isClickForward(button)) {
            return this.history.redo();
        }
        if (InputUtil.isClickBack(button)) {
            return this.history.undo();
        }
        if (InputUtil.isLeftClick(button) && !(this.method_25399() instanceof PackList)) {
            this.method_25395((class_364)this.method_25396().getFirst());
            this.layout.method_48206(w -> w.method_25365(false));
        }
        return false;
    }

    @Override
    public List<ToggleableDialog<?>> getDialogs() {
        return List.of(this.profiles.getSidebar(), this.options);
    }

    public Modal<class_8667> getOptionsDialog() {
        return this.options;
    }

    public void clearHistory() {
        this.history.reset(this.captureState());
    }

    @Override
    @NotNull
    public Snapshot captureState() {
        return new Snapshot(this, ((AvailablePackList)this.availablePacks.getList()).captureState(), ((CurrentPackList)this.currentPacks.getList()).captureState());
    }

    @Override
    public void replaceState(@NotNull Snapshot snapshot) {
        ImmutableList<class_3288> validPacks = this.repository.getPacks();
        this.availablePacks.getSortButton().setValueSilently(snapshot.availablePacks.query().getSort());
        this.availablePacks.getCompatButton().setValueSilently(snapshot.availablePacks.query().isHideIncompatible());
        snapshot.availablePacks.validate((List<class_3288>)validPacks).restore();
        snapshot.currentPacks.validate((List<class_3288>)validPacks).restore();
    }

    public static final class Snapshot
    extends Record
    implements Restorable.Snapshot<Snapshot> {
        private final PackedPacksScreen target;
        private final PackList.Snapshot availablePacks;
        private final PackList.Snapshot currentPacks;

        public Snapshot(PackedPacksScreen target, PackList.Snapshot availablePacks, PackList.Snapshot currentPacks) {
            this.target = target;
            this.availablePacks = availablePacks;
            this.currentPacks = currentPacks;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Snapshot.class, "target;availablePacks;currentPacks", "target", "availablePacks", "currentPacks"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Snapshot.class, "target;availablePacks;currentPacks", "target", "availablePacks", "currentPacks"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Snapshot.class, "target;availablePacks;currentPacks", "target", "availablePacks", "currentPacks"}, this, o);
        }

        public PackedPacksScreen target() {
            return this.target;
        }

        public PackList.Snapshot availablePacks() {
            return this.availablePacks;
        }

        public PackList.Snapshot currentPacks() {
            return this.currentPacks;
        }
    }
}

