/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.util.lang;

import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public class ObjectsUtil {
    private ObjectsUtil() {
    }

    public static <E> E pick(boolean condition, E ifTrue, E ifFalse) {
        return condition ? ifTrue : ifFalse;
    }

    @Nullable
    public static <E> E pick(E first, E second, Predicate<E> predicate) {
        if (predicate.test(first)) {
            return first;
        }
        if (predicate.test(second)) {
            return second;
        }
        return null;
    }

    @SafeVarargs
    @Nullable
    public static <E> E firstNonNull(E ... args) {
        for (E arg : args) {
            if (arg == null) continue;
            return arg;
        }
        return null;
    }

    public static <E> boolean testNullable(@Nullable E obj, Predicate<E> predicate) {
        if (obj == null) {
            return false;
        }
        return predicate.test(obj);
    }
}

