/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.util.pack;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.github.fishstiz.packed_packs.transform.interfaces.IPackSelectionModel;
import io.github.fishstiz.packed_packs.transform.mixin.PackSelectionModelAccessor;
import io.github.fishstiz.packed_packs.util.pack.PackIconCache;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_3283;
import net.minecraft.class_3288;
import net.minecraft.class_5369;

public class PackRepositoryHelper
implements PackIconCache {
    private final Map<String, class_2960> cachedIcons = new HashMap<String, class_2960>();
    private final Map<String, class_3288> availablePacks = new LinkedHashMap<String, class_3288>();
    private final class_3283 repository;
    private final Path packDir;
    private final class_5369 model;

    public PackRepositoryHelper(class_3283 repository, Path packDir) {
        this.repository = repository;
        this.packDir = packDir;
        this.model = new class_5369(PackRepositoryHelper::_update, PackRepositoryHelper::_getIcon, this.repository, PackRepositoryHelper::_apply);
        this.populateAvailablePacks();
    }

    public class_3283 getRepository() {
        return this.repository;
    }

    private List<class_3288> getSelectedPacks() {
        return ((PackSelectionModelAccessor)this.model).getSelectedPacks();
    }

    private List<class_3288> getUnselectedPacks() {
        return ((PackSelectionModelAccessor)this.model).getUnselectedPacks();
    }

    public ImmutableList<class_3288> getPacks() {
        return ImmutableList.copyOf(this.availablePacks.values());
    }

    public PackGroup getPacksByRequirement() {
        ArrayList<class_3288> required = new ArrayList<class_3288>();
        ArrayList<class_3288> optional = new ArrayList<class_3288>();
        for (class_3288 pack : this.availablePacks.values()) {
            if (pack.method_14464()) {
                required.add(pack);
                continue;
            }
            optional.add(pack);
        }
        return PackGroup.of(required, optional);
    }

    public PackGroup getPacksBySelected() {
        return PackGroup.of(this.getSelectedPacks(), this.getUnselectedPacks());
    }

    public PackGroup validatePacks(List<class_3288> unselected, List<class_3288> selected) {
        HashSet<class_3288> validPacks = new HashSet<class_3288>(this.availablePacks.values());
        HashSet<class_3288> previousUnselected = new HashSet<class_3288>(unselected);
        HashSet<class_3288> previousSelected = new HashSet<class_3288>(selected);
        ArrayList<class_3288> unselectedPacks = new ArrayList<class_3288>(unselected);
        ArrayList<class_3288> selectedPacks = new ArrayList<class_3288>(selected);
        unselectedPacks.retainAll(validPacks);
        selectedPacks.retainAll(validPacks);
        for (class_3288 pack : validPacks) {
            if (previousSelected.contains(pack) || previousUnselected.contains(pack)) continue;
            if (pack.method_14464()) {
                selectedPacks.add(pack);
                continue;
            }
            unselectedPacks.add(pack);
        }
        unselectedPacks.removeIf(new HashSet<class_3288>(selectedPacks)::contains);
        return PackGroup.of(selectedPacks, unselectedPacks);
    }

    public List<class_3288> getPacksById(List<String> packIds) {
        ArrayList<class_3288> packs = new ArrayList<class_3288>();
        for (String id : packIds) {
            class_3288 pack = this.availablePacks.get(id);
            if (pack == null) continue;
            packs.add(pack);
        }
        return packs;
    }

    private void populateAvailablePacks() {
        for (class_3288 pack : this.getSelectedPacks()) {
            this.availablePacks.put(pack.method_14463(), pack);
        }
        for (class_3288 pack : this.getUnselectedPacks()) {
            this.availablePacks.put(pack.method_14463(), pack);
        }
    }

    public void refresh() {
        ((IPackSelectionModel)this.model).packed_packs$reset();
        this.model.method_29981();
        this.availablePacks.clear();
        this.populateAvailablePacks();
    }

    public void selectPacks(List<class_3288> selected) {
        this.repository.method_14447((Collection)Lists.reverse(selected).stream().map(class_3288::method_14463).collect(ImmutableList.toImmutableList()));
    }

    public void openDirectory() {
        class_156.method_668().method_60932(this.packDir);
    }

    @Override
    public void getOrLoad(class_3288 pack, Consumer<class_2960> iconCallback) {
        class_2960 cachedIcon = this.cachedIcons.get(pack.method_14463());
        if (cachedIcon != null) {
            iconCallback.accept(cachedIcon);
        } else {
            iconCallback.accept(DEFAULT_ICON);
            PackIconCache.loadPackIcon(pack).thenAcceptAsync(location -> {
                this.cachedIcons.put(pack.method_14463(), (class_2960)location);
                iconCallback.accept((class_2960)location);
            });
        }
    }

    private static class_2960 _getIcon(class_3288 pack) {
        return DEFAULT_ICON;
    }

    private static void _update() {
    }

    private static void _apply(class_3283 repository) {
    }

    public record PackGroup(ImmutableList<class_3288> selected, ImmutableList<class_3288> unselected) {
        private static PackGroup of(List<class_3288> selected, List<class_3288> unselected) {
            return new PackGroup((ImmutableList<class_3288>)ImmutableList.copyOf(selected), (ImmutableList<class_3288>)ImmutableList.copyOf(unselected));
        }
    }
}

