/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.util.pack;

import io.github.fishstiz.packed_packs.PackedPacks;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_310;
import net.minecraft.class_3288;
import net.minecraft.class_8581;
import net.minecraft.class_8621;

public class PackUtil {
    private PackUtil() {
    }

    public static long getLastUpdatedEpochMs(class_3288 pack) {
        if (!pack.method_14463().matches("^file/.*")) {
            return -1L;
        }
        try {
            Path path = class_310.method_1551().method_1479().resolve(pack.method_14463().replaceFirst("^file/", ""));
            return Files.getLastModifiedTime(path, new LinkOption[0]).toInstant().toEpochMilli();
        }
        catch (IOException e) {
            PackedPacks.LOGGER.error("Failed to get age of pack '{}'", (Object)pack.method_14463());
            return -1L;
        }
    }

    public static Stream<String> extractPackNames(Collection<Path> paths) {
        return paths.stream().map(Path::getFileName).map(Path::toString);
    }

    public static class_8621<Path> createPackDetector() {
        return new class_8621<Path>(class_310.method_1551().method_52702()){

            protected Path createZipPack(Path path) {
                return path;
            }

            protected Path createDirectoryPack(Path path) {
                return path;
            }
        };
    }

    public static PackValidation validatePaths(List<Path> packs, class_8621<Path> packDetector) {
        ArrayList<Path> valid = new ArrayList<Path>(packs.size());
        HashSet<Path> rejected = new HashSet<Path>(packs);
        ArrayList<class_8581> symlinkWarnings = new ArrayList<class_8581>();
        for (Path path : packs) {
            try {
                Path detectedPack = (Path)packDetector.method_52441(path, symlinkWarnings);
                if (detectedPack == null) {
                    PackedPacks.LOGGER.warn("Path {} does not seem like pack", (Object)path);
                    continue;
                }
                valid.add(detectedPack);
                rejected.remove(detectedPack);
            }
            catch (IOException e) {
                PackedPacks.LOGGER.warn("Failed to check {} for packs", (Object)path, (Object)e);
            }
        }
        return new PackValidation(valid, rejected, symlinkWarnings);
    }

    public record PackValidation(List<Path> valid, Set<Path> rejected, List<class_8581> symlinkWarnings) {
    }
}

