/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.gui.components.events;

import io.github.fishstiz.packed_packs.gui.components.events.DragEvent;
import io.github.fishstiz.packed_packs.gui.components.pack.PackList;
import io.github.fishstiz.packed_packs.util.InputUtil;
import java.util.Optional;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.input.MouseButtonEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DragEventHandler
extends ContainerEventHandler {
    @Nullable
    public DragEvent getDragged();

    public void setDragged(DragEvent var1);

    default public boolean isDraggingSelection() {
        return this.getDragged() != null;
    }

    default public void handleDragEvent(DragEvent event) {
        if (!this.isDraggingSelection()) {
            this.setDragged(event);
        }
    }

    default public void onRelease(@NotNull DragEvent event, double mouseX, double mouseY) {
        Object t;
        Optional child = this.getChildAt(mouseX, mouseY);
        if (child.isPresent() && (t = child.get()) instanceof PackList) {
            PackList packList = (PackList)t;
            packList.drop(event, mouseX, mouseY);
        }
    }

    default public boolean mouseDragged(MouseButtonEvent mouseButtonEvent, double dragX, double dragY) {
        if (this.isDraggingSelection()) {
            return true;
        }
        return super.mouseDragged(mouseButtonEvent, dragX, dragY);
    }

    default public boolean mouseReleased(MouseButtonEvent mouseButtonEvent) {
        DragEvent event = this.getDragged();
        if (InputUtil.isLeftClick(mouseButtonEvent) && event != null) {
            this.onRelease(event, mouseButtonEvent.x(), mouseButtonEvent.y());
            this.setDragged(null);
            return true;
        }
        return super.mouseReleased(mouseButtonEvent);
    }
}

