/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.gui.components.events;

import io.github.fishstiz.fidgetz.gui.renderables.ColoredRect;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.Sprite;
import io.github.fishstiz.fidgetz.util.DrawUtil;
import io.github.fishstiz.packed_packs.gui.components.events.DragEvent;
import io.github.fishstiz.packed_packs.pack.PackAssetManager;
import io.github.fishstiz.packed_packs.util.constants.Theme;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;

public class DragEventRenderer {
    private static final int OFFSET_Y = 4;
    private static final int ICON_SIZE = 48;
    private static final int NUM_SIZE = 16;
    private static final int ICON_OFFSET_X = 24;
    private static final int ICON_OFFSET_Y = 44;
    private static final int NUM_OFFSET_Y = 28;
    private final ColoredRect background = new ColoredRect(Theme.GRAY_800.getARGB());
    private final ColoredRect overlay = new ColoredRect(Theme.BLACK.withAlpha(0.5f));
    private final ColoredRect numberBackground = new ColoredRect(Theme.BLUE_500.getARGB());
    private final PackAssetManager assetManager;

    public DragEventRenderer(PackAssetManager assetManager) {
        this.assetManager = assetManager;
    }

    public void renderDragEvent(DragEvent dragEvent, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int n;
        Sprite icon = this.assetManager.getIcon(dragEvent.trigger());
        String sizeString = String.valueOf(dragEvent.payload().size());
        Font font = Minecraft.getInstance().font;
        int sizeStringWidth = font.width(sizeString);
        int iconX = mouseX - 24;
        int iconY = mouseY - 44;
        if (16 > sizeStringWidth) {
            n = 16;
        } else {
            Objects.requireNonNull(font);
            n = sizeStringWidth + 16 - 9;
        }
        int numWidth = n;
        int numX = mouseX - numWidth / 2;
        int numY = mouseY - 28;
        this.background.render(guiGraphics, iconX, iconY, 48, 48);
        icon.render(guiGraphics, iconX, iconY, 48, 48, partialTick);
        this.overlay.render(guiGraphics, iconX, iconY, 48, 48);
        this.numberBackground.render(guiGraphics, numX, numY, numWidth, 16);
        int n2 = numX + numWidth / 2 - sizeStringWidth / 2;
        Objects.requireNonNull(font);
        guiGraphics.drawString(font, sizeString, n2, numY + 8 - 9 / 2, Theme.WHITE.getARGB());
        DrawUtil.renderOutline((GuiGraphics)guiGraphics, (int)iconX, (int)iconY, (int)48, (int)48, (int)Theme.WHITE.getARGB());
        DrawUtil.renderOutline((GuiGraphics)guiGraphics, (int)numX, (int)numY, (int)numWidth, (int)16, (int)Theme.WHITE.getARGB());
    }
}

